/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.transform.RuleMethodInterpreter;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;

public final class InstructionGraphCreator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.containsImplicitActions() || method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(method, "method");
        RuleMethodInterpreter interpreter = new RuleMethodInterpreter(method);
        RuleMethodAnalyzer analyzer = new RuleMethodAnalyzer(interpreter);
        analyzer.analyze(classNode.name, method);
        interpreter.finish();
    }

    private static final class RuleMethodAnalyzer
    extends Analyzer<BasicValue> {
        private final RuleMethodInterpreter interpreter;

        private RuleMethodAnalyzer(RuleMethodInterpreter interpreter) {
            super((Interpreter)Objects.requireNonNull(interpreter));
            this.interpreter = interpreter;
        }

        protected void newControlFlowEdge(int insn, int successor) {
            this.interpreter.newControlFlowEdge(insn, successor);
        }

        protected boolean newControlFlowExceptionEdge(int insn, int successor) {
            this.interpreter.newControlFlowEdge(insn, successor);
            return true;
        }
    }
}

