/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.stack;

import com.github.fge.grappa.stack.ValueStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class ValueStackBase<V>
implements ValueStack<V> {
    @Override
    public final void push(V value) {
        this.push(0, value);
    }

    @Override
    public final void push(int down, V value) {
        if (down < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.checkIndex(down - 1);
        Objects.requireNonNull(value);
        this.doPush(down, value);
    }

    protected abstract void doPush(int var1, V var2);

    @Override
    @Nonnull
    public final V pop() {
        return this.pop(0);
    }

    @Override
    @Nonnull
    public final V pop(int down) {
        if (down < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.checkIndex(down);
        return this.doPop(down);
    }

    @Override
    @Nonnull
    public final <T extends V> T popAs(Class<T> type) {
        return type.cast(this.pop(0));
    }

    @Override
    @Nonnull
    public final <T extends V> T popAs(Class<T> type, int down) {
        return type.cast(this.pop(down));
    }

    protected abstract V doPop(int var1);

    @Override
    @Nonnull
    public final V peek() {
        return this.peek(0);
    }

    @Override
    @Nonnull
    public final V peek(int down) {
        if (down < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.checkIndex(down);
        return this.doPeek(down);
    }

    @Override
    @Nonnull
    public final <T extends V> T peekAs(Class<T> type) {
        return type.cast(this.peek(0));
    }

    @Override
    @Nonnull
    public final <T extends V> T peekAs(Class<T> type, int down) {
        return type.cast(this.peek(down));
    }

    protected abstract V doPeek(int var1);

    @Override
    public final void poke(@Nonnull V value) {
        this.poke(0, value);
    }

    @Override
    public final void poke(int down, V value) {
        if (down < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.checkIndex(down);
        Objects.requireNonNull(value);
        this.doPoke(down, value);
    }

    protected abstract void doPoke(int var1, V var2);

    @Override
    public final void swap(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("argument must be >= 2");
        }
        this.checkIndex(n - 1);
        this.doSwap(n);
    }

    @Override
    public final void swap() {
        this.swap(2);
    }

    @Override
    public final void dup() {
        this.checkIndex(0);
        this.doDup();
    }

    protected abstract void doDup();

    protected abstract void doSwap(int var1);

    protected abstract void checkIndex(int var1);
}

