/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.parsers;

import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.run.context.Context;
import com.github.fge.grappa.run.context.ContextAware;
import com.github.fge.grappa.support.IndexRange;
import com.github.fge.grappa.support.Position;
import java.util.Objects;

public abstract class BaseActions<V>
implements ContextAware<V> {
    private Context<V> context;

    public final Context<V> getContext() {
        return this.context;
    }

    @Override
    public final void setContext(Context<V> context) {
        this.context = Objects.requireNonNull(context, "context");
    }

    public final int currentIndex() {
        this.check();
        return this.context.getCurrentIndex();
    }

    public String match() {
        this.check();
        return this.context.getMatch();
    }

    public IndexRange matchRange() {
        this.check();
        return this.context.getMatchRange();
    }

    public String matchOrDefault(String defaultString) {
        this.check();
        String match = this.context.getMatch();
        return match.isEmpty() ? defaultString : match;
    }

    public char matchedChar() {
        this.check();
        return this.context.getFirstMatchChar();
    }

    public int matchStart() {
        this.check();
        return this.context.getMatchStartIndex();
    }

    public int matchEnd() {
        this.check();
        return this.context.getMatchEndIndex();
    }

    public int matchLength() {
        this.check();
        return this.context.getMatchLength();
    }

    public Position position() {
        this.check();
        return this.context.getPosition();
    }

    public boolean push(V value) {
        this.check();
        this.context.getValueStack().push(value);
        return true;
    }

    public boolean push(int down, V value) {
        this.check();
        this.context.getValueStack().push(down, value);
        return true;
    }

    public V pop() {
        this.check();
        return this.context.getValueStack().pop();
    }

    public V pop(int down) {
        this.check();
        return this.context.getValueStack().pop(down);
    }

    public boolean drop() {
        this.check();
        this.context.getValueStack().pop();
        return true;
    }

    public boolean drop(int down) {
        this.check();
        this.context.getValueStack().pop(down);
        return true;
    }

    public V peek() {
        this.check();
        return this.context.getValueStack().peek();
    }

    public V peek(int down) {
        this.check();
        return this.context.getValueStack().peek(down);
    }

    public boolean poke(V value) {
        this.check();
        this.context.getValueStack().poke(value);
        return true;
    }

    public boolean poke(int down, V value) {
        this.check();
        this.context.getValueStack().poke(down, value);
        return true;
    }

    public boolean dup() {
        this.check();
        this.context.getValueStack().dup();
        return true;
    }

    public boolean swap() {
        this.check();
        this.context.getValueStack().swap();
        return true;
    }

    public boolean swap(int n) {
        this.check();
        this.context.getValueStack().swap(n);
        return true;
    }

    public Character currentChar() {
        this.check();
        return Character.valueOf(this.context.getCurrentChar());
    }

    public boolean inPredicate() {
        this.check();
        return this.context.inPredicate();
    }

    public boolean hasError() {
        this.check();
        return this.context.hasError();
    }

    private void check() {
        if (this.context == null || this.context.getMatcher() == null) {
            throw new InvalidGrammarException("rule has an unwrapped action expression");
        }
    }
}

