/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.unicode;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;

public final class CodePointMatcher
extends AbstractMatcher {
    private final int codePoint;
    private final int codePointLength;

    public CodePointMatcher(int codePoint) {
        super(String.format("U+%04X", codePoint));
        this.codePoint = codePoint;
        this.codePointLength = codePoint < 65536 ? 1 : 2;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.codePoint != context.getInputBuffer().codePointAt(context.getCurrentIndex())) {
            return false;
        }
        context.advanceIndex(this.codePointLength);
        return true;
    }
}

