/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.join;

import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.CustomDefaultLabelMatcher;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.context.MatcherContext;

public abstract class JoinMatcher
extends CustomDefaultLabelMatcher<JoinMatcher> {
    private static final int JOINED_CHILD_INDEX = 0;
    private static final int JOINING_CHILD_INDEX = 1;
    protected final Matcher joined = (Matcher)this.getChildren().get(0);
    protected final Matcher joining = (Matcher)this.getChildren().get(1);

    protected JoinMatcher(Rule joined, Rule joining) {
        super(new Rule[]{joined, joining}, "join");
    }

    @Override
    public final MatcherType getType() {
        return MatcherType.COMPOSITE;
    }

    @Override
    public final <V> boolean match(MatcherContext<V> context) {
        int cycles = 0;
        if (!this.joined.getSubContext(context).runMatcher()) {
            return this.enoughCycles(cycles);
        }
        ++cycles;
        Object snapshot = context.getValueStack().takeSnapshot();
        int beforeCycle = context.getCurrentIndex();
        while (this.runAgain(cycles) && this.matchCycle(context, beforeCycle)) {
            beforeCycle = context.getCurrentIndex();
            snapshot = context.getValueStack().takeSnapshot();
            ++cycles;
        }
        context.getValueStack().restoreSnapshot(snapshot);
        context.setCurrentIndex(beforeCycle);
        return this.enoughCycles(cycles);
    }

    protected abstract boolean runAgain(int var1);

    protected abstract boolean enoughCycles(int var1);

    protected final <V> boolean matchCycle(MatcherContext<V> context, int beforeCycle) {
        if (!this.joining.getSubContext(context).runMatcher()) {
            return false;
        }
        if (context.getCurrentIndex() == beforeCycle) {
            throw new GrappaException("joining rule (" + this.joining + ") of a " + "JoinMatcher cannot match an empty character sequence!");
        }
        return this.joined.getSubContext(context).runMatcher();
    }
}

