/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.support.Chars;
import com.google.common.base.Preconditions;

public final class CharRangeMatcher
extends AbstractMatcher {
    private final char lowerBound;
    private final char upperBound;

    public CharRangeMatcher(char lowerBound, char upperBound) {
        super(Chars.escape(lowerBound) + ".." + Chars.escape(upperBound));
        Preconditions.checkArgument((lowerBound < upperBound ? 1 : 0) != 0);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        char c = context.getCurrentChar();
        if (c < this.lowerBound || c > this.upperBound) {
            return false;
        }
        context.advanceIndex(1);
        return true;
    }
}

