/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.support.Chars;

public final class CharIgnoreCaseMatcher
extends AbstractMatcher {
    private final char lowerBound;
    private final char upperBound;

    public CharIgnoreCaseMatcher(char character) {
        super('\'' + Chars.escape(Character.toLowerCase(character)) + '/' + Chars.escape(Character.toUpperCase(character)) + '\'');
        this.lowerBound = Character.toLowerCase(character);
        this.upperBound = Character.toUpperCase(character);
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        char c = context.getCurrentChar();
        if (c != this.lowerBound && c != this.upperBound) {
            return false;
        }
        context.advanceIndex(1);
        return true;
    }
}

