/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.buffers;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.buffers.LineCounter;
import com.github.fge.grappa.support.IndexRange;
import com.github.fge.grappa.support.Position;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CharSequenceInputBuffer
implements InputBuffer {
    private static final ExecutorService EXECUTOR_SERVICE;
    private final CharSequence charSequence;
    private final Future<LineCounter> lineCounter;

    public CharSequenceInputBuffer(final @Nonnull CharSequence charSequence) {
        this.charSequence = Objects.requireNonNull(charSequence);
        this.lineCounter = EXECUTOR_SERVICE.submit(new Callable<LineCounter>(){

            @Override
            public LineCounter call() throws Exception {
                return new LineCounter(charSequence);
            }
        });
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative");
        }
        return index < this.charSequence.length() ? this.charSequence.charAt(index) : (char)'\uffff';
    }

    @Override
    public int codePointAt(int index) {
        int length = this.charSequence.length();
        if (index >= length) {
            return -1;
        }
        if (index < 0) {
            throw new IllegalArgumentException("index is negative");
        }
        int c = this.charSequence.charAt(index);
        if (!Character.isHighSurrogate((char)c)) {
            return c;
        }
        if (index == length - 1) {
            return c;
        }
        char c2 = this.charSequence.charAt(index + 1);
        return Character.isLowSurrogate(c2) ? Character.toCodePoint((char)c, c2) : c;
    }

    @Override
    public String extract(int start, int end) {
        int realStart = Math.max(start, 0);
        int realEnd = Math.min(end, this.charSequence.length());
        return this.charSequence.subSequence(realStart, realEnd).toString();
    }

    @Override
    public String extract(IndexRange range) {
        return this.extract(range.start, range.end);
    }

    @Override
    public Position getPosition(int index) {
        return ((LineCounter)Futures.getUnchecked(this.lineCounter)).toPosition(index);
    }

    @Override
    public String extractLine(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (Object)"line number is negative");
        LineCounter counter = (LineCounter)Futures.getUnchecked(this.lineCounter);
        Range<Integer> range = counter.getLineRange(lineNumber);
        int start = (Integer)range.lowerEndpoint();
        int end = (Integer)range.upperEndpoint();
        if (this.charAt(end - 1) == '\n') {
            --end;
        }
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    @Override
    public IndexRange getLineRange(int lineNumber) {
        Range<Integer> range = ((LineCounter)Futures.getUnchecked(this.lineCounter)).getLineRange(lineNumber);
        return new IndexRange((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint());
    }

    @Override
    public int getLineCount() {
        return ((LineCounter)Futures.getUnchecked(this.lineCounter)).getNrLines();
    }

    @Override
    public int length() {
        return this.charSequence.length();
    }

    static {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("linecounter-thread-%d").build();
        EXECUTOR_SERVICE = Executors.newCachedThreadPool(factory);
    }
}

