/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.notifications;

import com.notnoop.mpns.DeliveryClass;
import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.internal.Utilities;
import com.notnoop.mpns.notifications.AbstractNotificationBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToastNotification
implements MpnsNotification {
    private final Builder builder;
    private final List<? extends Map.Entry<String, String>> headers;

    public ToastNotification(Builder builder, List<? extends Map.Entry<String, String>> headers) {
        this.builder = builder;
        this.headers = headers;
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    @Override
    public byte[] getRequestBody() {
        return this.builder.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractNotificationBuilder<Builder, ToastNotification> {
        private String title;
        private String subtitle;
        private String parameter;

        public Builder() {
            super("toast");
            this.contentType(Utilities.XML_CONTENT_TYPE);
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            if (delivery == null) {
                delivery = DeliveryClass.IMMEDIATELY;
            }
            switch (delivery) {
                case IMMEDIATELY: {
                    return 2;
                }
                case WITHIN_450: {
                    return 12;
                }
                case WITHIN_900: {
                    return 22;
                }
            }
            return 2;
        }

        @Override
        public ToastNotification build() {
            return new ToastNotification(this, this.headers);
        }

        public byte[] toByteArray() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append("<wp:Notification xmlns:wp=\"WPNotification\">");
            sb.append("<wp:Toast>");
            sb.append(Utilities.xmlElement("Text1", this.title));
            sb.append(Utilities.xmlElement("Text2", this.subtitle));
            sb.append(Utilities.xmlElement("Param", this.parameter));
            sb.append("</wp:Toast>");
            sb.append("</wp:Notification>");
            return Utilities.toUTF8(sb.toString());
        }
    }
}

