/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.internal;

import com.notnoop.mpns.MpnsDelegate;
import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.MpnsService;
import com.notnoop.mpns.exceptions.NetworkIOException;
import com.notnoop.mpns.internal.AbstractMpnsService;
import com.notnoop.mpns.internal.Utilities;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class MpnsServiceImpl
extends AbstractMpnsService
implements MpnsService {
    private final HttpClient httpClient;
    private final MpnsDelegate delegate;

    public MpnsServiceImpl(HttpClient httpClient, MpnsDelegate delegate) {
        this.httpClient = httpClient;
        this.delegate = delegate;
    }

    protected void push(HttpPost request, MpnsNotification message) {
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            Utilities.fireDelegate(message, response, this.delegate, this.getSubscriptionUri(request));
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new NetworkIOException(e);
        }
    }

    public void stop() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

