/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape.viewhelper;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.github.fastshape.R;
import com.github.fastshape.inter.CompleteInter;
import com.github.fastshape.viewhelper.ClipHelper;
import com.github.fastshape.viewhelper.SetBackgroundUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FirstHelper
extends ClipHelper {
    protected int firstLayerType = 0;
    protected Drawable drawable_normal;
    protected Drawable drawable_press;
    protected int pressColor;
    protected boolean left_line;
    protected boolean top_line;
    protected boolean right_line;
    protected boolean bottom_line;
    protected int shapeType;
    public static final int shapeType_rectangle = 0;
    public static final int shapeType_oval = 1;
    public static final int shapeType_line = 2;
    protected float borderWidth;
    protected int borderColor;
    protected float borderDashWidth;
    protected float borderDashGap;
    protected int solidColor;
    protected int[] partBorderWidth;
    protected float topLeftRadius;
    protected float topRightRadius;
    protected float bottomLeftRadius;
    protected float bottomRightRadius;
    protected int gradientType;
    public static final int gradientType_none = -1;
    public static final int gradientType_linear = 0;
    public static final int gradientType_radial = 1;
    public static final int gradientType_sweep = 2;
    protected int gradientAngle;
    public static final int angle_0 = 0;
    public static final int angle_45 = 45;
    public static final int angle_90 = 90;
    public static final int angle_135 = 135;
    public static final int angle_180 = 180;
    public static final int angle_225 = 225;
    public static final int angle_270 = 270;
    public static final int angle_315 = 315;
    protected float gradientCenterX;
    protected float gradientCenterY;
    protected int gradientStartColor;
    protected int gradientCenterColor;
    protected int gradientEndColor;
    protected float gradientRadius;
    protected boolean isPartBorder;

    public FirstHelper complete() {
        if (this.completeInter != null) {
            this.completeInter.complete();
        }
        return this;
    }

    public FirstHelper(CompleteInter completeInter) {
        this.completeInter = completeInter;
    }

    public void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray viewNormal = context.obtainStyledAttributes(attrs, R.styleable.FastShapeAttr, defStyleAttr, 0);
        this.publicFirstAttr(viewNormal);
        this.clipAttr(viewNormal);
        viewNormal.recycle();
    }

    protected void clipAttr(TypedArray viewNormal) {
        this.clipSwitch = viewNormal.getBoolean(R.styleable.FastShapeAttr_clipSwitch, false);
        float clipRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_clipRadius, 0.0f);
        if (clipRadius > 0.0f) {
            this.clipTopLeftRadius = clipRadius;
            this.clipTopRightRadius = clipRadius;
            this.clipBottomLeftRadius = clipRadius;
            this.clipBottomRightRadius = clipRadius;
        } else {
            this.clipTopLeftRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_clipTopLeftRadius, 0.0f);
            this.clipTopRightRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_clipTopRightRadius, 0.0f);
            this.clipBottomLeftRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_clipBottomLeftRadius, 0.0f);
            this.clipBottomRightRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_clipBottomRightRadius, 0.0f);
        }
        this.clipBg = viewNormal.getBoolean(R.styleable.FastShapeAttr_clipBg, true);
        this.clipIgnorePadding = viewNormal.getBoolean(R.styleable.FastShapeAttr_clipIgnorePadding, true);
        this.clipIsCircle = viewNormal.getBoolean(R.styleable.FastShapeAttr_clipIsCircle, false);
        this.clipIsAreaClick = viewNormal.getBoolean(R.styleable.FastShapeAttr_clipIsAreaClick, true);
        this.clipBorderWidth = viewNormal.getDimension(R.styleable.FastShapeAttr_clipBorderWidth, 0.0f);
        this.clipBorderColor = viewNormal.getColor(R.styleable.FastShapeAttr_clipBorderColor, -1);
        this.clipBorderDashWidth = viewNormal.getDimension(R.styleable.FastShapeAttr_clipBorderDashWidth, 0.0f);
        this.clipBorderDashGap = viewNormal.getDimension(R.styleable.FastShapeAttr_clipBorderDashGap, 0.0f);
        this.clipBorderDashBgColor = viewNormal.getColor(R.styleable.FastShapeAttr_clipBorderDashBgColor, 0);
        this.clipBorderPhase = viewNormal.getInt(R.styleable.FastShapeAttr_clipBorderPhase, 0);
    }

    protected void publicFirstAttr(TypedArray viewNormal) {
        Drawable drawable_normal = viewNormal.getDrawable(R.styleable.FastShapeAttr_drawable_normal);
        Drawable drawable_press = viewNormal.getDrawable(R.styleable.FastShapeAttr_drawable_press);
        if (drawable_normal != null || drawable_press != null) {
            this.drawable_normal = drawable_normal;
            this.drawable_press = drawable_press;
            if (drawable_normal == null) {
                this.drawable_normal = drawable_press;
            }
            if (drawable_press == null) {
                this.drawable_press = drawable_normal;
            }
            return;
        }
        this.pressColor = viewNormal.getColor(R.styleable.FastShapeAttr_pressColor, 0);
        this.left_line = viewNormal.getBoolean(R.styleable.FastShapeAttr_left_line, false);
        this.top_line = viewNormal.getBoolean(R.styleable.FastShapeAttr_top_line, false);
        this.right_line = viewNormal.getBoolean(R.styleable.FastShapeAttr_right_line, false);
        this.bottom_line = viewNormal.getBoolean(R.styleable.FastShapeAttr_bottom_line, false);
        this.isPartBorder = this.left_line && this.top_line && this.right_line && this.bottom_line ? false : this.left_line || this.top_line || this.right_line || this.bottom_line;
        this.shapeType = viewNormal.getInteger(R.styleable.FastShapeAttr_shapeType, 0);
        this.borderWidth = viewNormal.getDimension(R.styleable.FastShapeAttr_borderWidth, 0.0f);
        this.borderColor = viewNormal.getColor(R.styleable.FastShapeAttr_borderColor, 0);
        this.borderDashWidth = viewNormal.getDimension(R.styleable.FastShapeAttr_borderDashWidth, 0.0f);
        this.borderDashGap = viewNormal.getDimension(R.styleable.FastShapeAttr_borderDashGap, 0.0f);
        this.solidColor = viewNormal.getColor(R.styleable.FastShapeAttr_solidColor, 0);
        float radius = viewNormal.getDimension(R.styleable.FastShapeAttr_radius, 0.0f);
        if (radius > 0.0f) {
            this.topLeftRadius = radius;
            this.topRightRadius = radius;
            this.bottomLeftRadius = radius;
            this.bottomRightRadius = radius;
        } else {
            this.topLeftRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_topLeftRadius, 0.0f);
            this.topRightRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_topRightRadius, 0.0f);
            this.bottomLeftRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_bottomLeftRadius, 0.0f);
            this.bottomRightRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_bottomRightRadius, 0.0f);
        }
        this.gradientType = viewNormal.getInteger(R.styleable.FastShapeAttr_gradientType, -1);
        if (this.gradientType != -1) {
            this.gradientAngle = viewNormal.getInteger(R.styleable.FastShapeAttr_gradientAngle, 0);
            this.gradientCenterX = viewNormal.getFloat(R.styleable.FastShapeAttr_gradientCenterX, 0.5f);
            this.gradientCenterY = viewNormal.getFloat(R.styleable.FastShapeAttr_gradientCenterY, 0.5f);
            this.gradientStartColor = viewNormal.getColor(R.styleable.FastShapeAttr_gradientStartColor, 0);
            this.gradientCenterColor = viewNormal.getColor(R.styleable.FastShapeAttr_gradientCenterColor, 0);
            this.gradientEndColor = viewNormal.getColor(R.styleable.FastShapeAttr_gradientEndColor, 0);
            this.gradientRadius = viewNormal.getDimension(R.styleable.FastShapeAttr_gradientRadius, 40.0f);
        }
    }

    public FirstHelper clearShapeAttr() {
        this.drawable_normal = null;
        this.drawable_press = null;
        this.pressColor = SetBackgroundUtil.getTransparentColor();
        this.left_line = false;
        this.top_line = false;
        this.right_line = false;
        this.bottom_line = false;
        this.shapeType = 0;
        this.borderWidth = 0.0f;
        this.borderColor = SetBackgroundUtil.getTransparentColor();
        this.borderDashWidth = 0.0f;
        this.borderDashGap = 0.0f;
        this.solidColor = SetBackgroundUtil.getTransparentColor();
        this.topLeftRadius = 0.0f;
        this.topRightRadius = 0.0f;
        this.bottomLeftRadius = 0.0f;
        this.bottomRightRadius = 0.0f;
        this.gradientType = -1;
        this.gradientAngle = 0;
        this.gradientCenterX = 0.5f;
        this.gradientCenterY = 0.5f;
        this.gradientStartColor = 0;
        this.gradientCenterColor = 0;
        this.gradientEndColor = 0;
        this.gradientRadius = 40.0f;
        return this;
    }

    public Drawable getDrawable_normal() {
        return this.drawable_normal;
    }

    public FirstHelper setDrawable_normal(Drawable drawable_normal) {
        this.drawable_normal = drawable_normal;
        return this;
    }

    public Drawable getDrawable_press() {
        return this.drawable_press;
    }

    public FirstHelper setDrawable_press(Drawable drawable_press) {
        this.drawable_press = drawable_press;
        return this;
    }

    public int getPressColor() {
        return this.pressColor;
    }

    public FirstHelper setPressColor(int pressColor) {
        this.pressColor = pressColor;
        return this;
    }

    public boolean isLeft_line() {
        return this.left_line;
    }

    public FirstHelper setLeft_line(boolean left_line) {
        this.left_line = left_line;
        return this;
    }

    public boolean isTop_line() {
        return this.top_line;
    }

    public FirstHelper setTop_line(boolean top_line) {
        this.top_line = top_line;
        return this;
    }

    public boolean isRight_line() {
        return this.right_line;
    }

    public FirstHelper setRight_line(boolean right_line) {
        this.right_line = right_line;
        return this;
    }

    public boolean isBottom_line() {
        return this.bottom_line;
    }

    public FirstHelper setBottom_line(boolean bottom_line) {
        this.bottom_line = bottom_line;
        return this;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public FirstHelper setShapeType(int shapeType2) {
        this.shapeType = shapeType2;
        return this;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public FirstHelper setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public FirstHelper setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public float getBorderDashWidth() {
        return this.borderDashWidth;
    }

    public FirstHelper setBorderDashWidth(float borderDashWidth) {
        this.borderDashWidth = borderDashWidth;
        return this;
    }

    public float getBorderDashGap() {
        return this.borderDashGap;
    }

    public FirstHelper setBorderDashGap(float borderDashGap) {
        this.borderDashGap = borderDashGap;
        return this;
    }

    public int getSolidColor() {
        return this.solidColor;
    }

    public FirstHelper setSolidColor(int solidColor) {
        this.solidColor = solidColor;
        return this;
    }

    public FirstHelper setRadius(float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        this.setTopLeftRadius(topLeftRadius);
        this.setTopRightRadius(topRightRadius);
        this.setBottomRightRadius(bottomRightRadius);
        this.setBottomLeftRadius(bottomLeftRadius);
        return this;
    }

    public FirstHelper setRadius(float radius) {
        return this.setRadius(radius, radius, radius, radius);
    }

    public float getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public FirstHelper setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public float getTopRightRadius() {
        return this.topRightRadius;
    }

    public FirstHelper setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
        return this;
    }

    public float getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public FirstHelper setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    public float getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public FirstHelper setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public int getGradientType() {
        return this.gradientType;
    }

    public FirstHelper setGradientType(int gradientType2) {
        this.gradientType = gradientType2;
        return this;
    }

    public int getGradientAngle() {
        return this.gradientAngle;
    }

    public FirstHelper setGradientAngle(int gradientAngle) {
        this.gradientAngle = gradientAngle;
        return this;
    }

    public float getGradientCenterX() {
        return this.gradientCenterX;
    }

    public FirstHelper setGradientCenterX(float gradientCenterX) {
        this.gradientCenterX = gradientCenterX;
        return this;
    }

    public float getGradientCenterY() {
        return this.gradientCenterY;
    }

    public FirstHelper setGradientCenterY(float gradientCenterY) {
        this.gradientCenterY = gradientCenterY;
        return this;
    }

    public int getGradientStartColor() {
        return this.gradientStartColor;
    }

    public FirstHelper setGradientStartColor(int gradientStartColor) {
        this.gradientStartColor = gradientStartColor;
        return this;
    }

    public int getGradientCenterColor() {
        return this.gradientCenterColor;
    }

    public FirstHelper setGradientCenterColor(int gradientCenterColor) {
        this.gradientCenterColor = gradientCenterColor;
        return this;
    }

    public int getGradientEndColor() {
        return this.gradientEndColor;
    }

    public FirstHelper setGradientEndColor(int gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
        return this;
    }

    public float getGradientRadius() {
        return this.gradientRadius;
    }

    public FirstHelper setGradientRadius(float gradientRadius) {
        this.gradientRadius = gradientRadius;
        return this;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface angleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface gradientType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface shapeType {
    }
}

