/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import com.github.fastshape.R;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
public class FlowLayout
extends ViewGroup {
    private int mGravity = (FlowLayout.isIcs() ? 0x800003 : 3) | 0x30;
    private final List<List<View>> mLines = new ArrayList<List<View>>();
    private final List<Integer> mLineHeights = new ArrayList<Integer>();
    private final List<Integer> mLineMargins = new ArrayList<Integer>();

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlowLayout, defStyle, 0);
        try {
            int index = a.getInt(R.styleable.FlowLayout_android_gravity, -1);
            if (index > 0) {
                this.setGravity(index);
            }
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = this.getPaddingTop() + this.getPaddingBottom();
        int lineWidth = 0;
        int lineHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean lastChild;
            View child = this.getChildAt(i);
            boolean bl = lastChild = i == childCount - 1;
            if (child.getVisibility() == 8) {
                if (!lastChild) continue;
                width = Math.max(width, lineWidth);
                height += lineHeight;
                continue;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, lineWidth, heightMeasureSpec, height);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidthMode = Integer.MIN_VALUE;
            int childWidthSize = sizeWidth;
            int childHeightMode = Integer.MIN_VALUE;
            int childHeightSize = sizeHeight;
            if (lp.width == -1) {
                childWidthMode = 0x40000000;
                childWidthSize -= lp.leftMargin + lp.rightMargin;
            } else if (lp.width >= 0) {
                childWidthMode = 0x40000000;
                childWidthSize = lp.width;
            }
            if (lp.height >= 0) {
                childHeightMode = 0x40000000;
                childHeightSize = lp.height;
            } else if (modeHeight == 0) {
                childHeightMode = 0;
                childHeightSize = 0;
            }
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)childHeightMode));
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            if (lineWidth + childWidth > sizeWidth) {
                width = Math.max(width, lineWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            if (!lastChild) continue;
            width = Math.max(width, lineWidth);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : (width += this.getPaddingLeft() + this.getPaddingRight()), modeHeight == 0x40000000 ? sizeHeight : height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        float horizontalGravityFactor;
        this.mLines.clear();
        this.mLineHeights.clear();
        this.mLineMargins.clear();
        int width = this.getWidth();
        int height = this.getHeight();
        int linesSum = this.getPaddingTop();
        int lineWidth = 0;
        int lineHeight = 0;
        List<Object> lineViews = new ArrayList<View>();
        switch (this.mGravity & 7) {
            default: {
                horizontalGravityFactor = 0.0f;
                break;
            }
            case 1: {
                horizontalGravityFactor = 0.5f;
                break;
            }
            case 5: {
                horizontalGravityFactor = 1.0f;
            }
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.bottomMargin + lp.topMargin;
            if (lineWidth + childWidth > width) {
                this.mLineHeights.add(lineHeight);
                this.mLines.add(lineViews);
                this.mLineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor) + this.getPaddingLeft());
                linesSum += lineHeight;
                lineHeight = 0;
                lineWidth = 0;
                lineViews = new ArrayList();
            }
            lineWidth += childWidth;
            lineHeight = Math.max(lineHeight, childHeight);
            lineViews.add(child);
        }
        this.mLineHeights.add(lineHeight);
        this.mLines.add(lineViews);
        this.mLineMargins.add((int)((float)(width - lineWidth) * horizontalGravityFactor) + this.getPaddingLeft());
        linesSum += lineHeight;
        int verticalGravityMargin = 0;
        switch (this.mGravity & 0x70) {
            default: {
                break;
            }
            case 16: {
                verticalGravityMargin = (height - linesSum) / 2;
                break;
            }
            case 80: {
                verticalGravityMargin = height - linesSum;
            }
        }
        int numLines = this.mLines.size();
        int top = this.getPaddingTop();
        for (int i = 0; i < numLines; ++i) {
            lineHeight = this.mLineHeights.get(i);
            lineViews = this.mLines.get(i);
            int left = this.mLineMargins.get(i);
            int children = lineViews.size();
            for (int j = 0; j < children; ++j) {
                View child = (View)lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.height == -1) {
                    int childWidthMode = Integer.MIN_VALUE;
                    int childWidthSize = lineWidth;
                    if (lp.width == -1) {
                        childWidthMode = 0x40000000;
                    } else if (lp.width >= 0) {
                        childWidthMode = 0x40000000;
                        childWidthSize = lp.width;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)childWidthMode), View.MeasureSpec.makeMeasureSpec((int)(lineHeight - lp.topMargin - lp.bottomMargin), (int)0x40000000));
                }
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                int gravityMargin = 0;
                if (Gravity.isVertical((int)lp.gravity)) {
                    switch (lp.gravity) {
                        default: {
                            break;
                        }
                        case 16: 
                        case 17: {
                            gravityMargin = (lineHeight - childHeight - lp.topMargin - lp.bottomMargin) / 2;
                            break;
                        }
                        case 80: {
                            gravityMargin = lineHeight - childHeight - lp.topMargin - lp.bottomMargin;
                        }
                    }
                }
                child.layout(left + lp.leftMargin, top + lp.topMargin + gravityMargin + verticalGravityMargin, left + childWidth + lp.leftMargin, top + childHeight + lp.topMargin + gravityMargin + verticalGravityMargin);
                left += childWidth + lp.leftMargin + lp.rightMargin;
            }
            top += lineHeight;
        }
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @TargetApi(value=14)
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= FlowLayout.isIcs() ? 0x800003 : 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    private static boolean isIcs() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FlowLayout_Layout);
            try {
                this.gravity = a.getInt(R.styleable.FlowLayout_Layout_android_layout_gravity, -1);
            }
            finally {
                a.recycle();
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

