/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape.viewhelper;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.fastshape.viewhelper.FirstHelper;
import com.github.fastshape.viewhelper.SecondHelper;
import com.github.fastshape.viewhelper.ThirdHelper;
import java.math.BigDecimal;

public class SetBackgroundUtil {
    public static <T extends FirstHelper> void viewComplete(View myView, T firstHelper) {
        if (firstHelper.drawable_normal != null) {
            StateListDrawable stateListDrawableForLayer = new StateListDrawable();
            stateListDrawableForLayer.addState(new int[]{-16842919}, firstHelper.drawable_normal);
            stateListDrawableForLayer.addState(new int[]{16842919}, firstHelper.drawable_press);
            stateListDrawableForLayer.addState(new int[0], firstHelper.drawable_normal);
            if (Build.VERSION.SDK_INT >= 16) {
                myView.setBackground((Drawable)stateListDrawableForLayer);
            } else {
                myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
            }
            return;
        }
        firstHelper.isPartBorder = firstHelper.left_line && firstHelper.top_line && firstHelper.right_line && firstHelper.bottom_line ? false : firstHelper.left_line || firstHelper.top_line || firstHelper.right_line || firstHelper.bottom_line;
        if (firstHelper.shapeType == 2 && myView.getLayerType() == 0) {
            if (!(myView instanceof ImageView)) {
                myView.setLayerType(1, null);
            }
        } else {
            myView.setLayerType(0, null);
        }
        if (!firstHelper.isPartBorder) {
            if (firstHelper.pressColor == 0) {
                SetBackgroundUtil.noPartBorderNoPressColor(myView, firstHelper);
            } else {
                SetBackgroundUtil.noPartBorderHasPressColor(myView, firstHelper);
            }
        } else if (firstHelper.pressColor == 0) {
            SetBackgroundUtil.hasPartBorderNoPressColor(myView, firstHelper);
        } else {
            SetBackgroundUtil.hasPartBorderHasPressColor(myView, firstHelper);
        }
    }

    public static <T extends SecondHelper> void setCompoundDrawables(TextView myView, T secondHelper) {
        int height;
        int width;
        boolean bottomFlag;
        boolean leftFlag = secondHelper.getLeft_width() > 0 || secondHelper.getLeft_height() > 0;
        boolean topFlag = secondHelper.getTop_width() > 0 || secondHelper.getTop_height() > 0;
        boolean rightFlag = secondHelper.getRight_width() > 0 || secondHelper.getRight_height() > 0;
        boolean bl = bottomFlag = secondHelper.getBottom_width() > 0 || secondHelper.getBottom_height() > 0;
        if (!(leftFlag || topFlag || rightFlag || bottomFlag)) {
            return;
        }
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        if (drawable0 != null) {
            width = drawable0.getIntrinsicWidth();
            height = drawable0.getIntrinsicHeight();
            drawable0.setBounds(0, 0, SetBackgroundUtil.getLeftWH(width, height, secondHelper)[0], SetBackgroundUtil.getLeftWH(width, height, secondHelper)[1]);
        }
        if (drawable1 != null) {
            width = drawable1.getIntrinsicWidth();
            height = drawable1.getIntrinsicHeight();
            drawable1.setBounds(0, 0, SetBackgroundUtil.getTopWH(width, height, secondHelper)[0], SetBackgroundUtil.getTopWH(width, height, secondHelper)[1]);
        }
        if (drawable2 != null) {
            width = drawable2.getIntrinsicWidth();
            height = drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, SetBackgroundUtil.getRightWH(width, height, secondHelper)[0], SetBackgroundUtil.getRightWH(width, height, secondHelper)[1]);
        }
        if (drawable3 != null) {
            width = drawable3.getIntrinsicWidth();
            height = drawable3.getIntrinsicHeight();
            drawable3.setBounds(0, 0, SetBackgroundUtil.getBottomWH(width, height, secondHelper)[0], SetBackgroundUtil.getBottomWH(width, height, secondHelper)[1]);
        }
        myView.setCompoundDrawables(drawable0, drawable1, drawable2, drawable3);
    }

    public static <T extends ThirdHelper> void setCompoundDrawables(CompoundButton myView, T thirdHelper) {
        SetBackgroundUtil.setLeftDrawable(myView, thirdHelper);
        SetBackgroundUtil.setTopDrawable(myView, thirdHelper);
        SetBackgroundUtil.setRightDrawable(myView, thirdHelper);
        SetBackgroundUtil.setBottomDrawable(myView, thirdHelper);
        int[][] colorState = new int[2][];
        int[] myColor = new int[]{thirdHelper.checked_textColor, thirdHelper.normal_textColor};
        colorState[0] = new int[]{0x10100A0};
        colorState[1] = new int[0];
        ColorStateList colorStateList = new ColorStateList((int[][])colorState, myColor);
        myView.setTextColor(colorStateList);
    }

    private static <T extends ThirdHelper> void setBottomDrawable(CompoundButton myView, T thirdHelper) {
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        SetBackgroundUtil.setNullColorFilter(drawable0);
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        SetBackgroundUtil.setNullColorFilter(drawable1);
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        SetBackgroundUtil.setNullColorFilter(drawable2);
        if (thirdHelper.normal_drawable_bottom != null && thirdHelper.checked_drawable_bottom != null) {
            if (thirdHelper.checked_drawable_bottom_color != -1) {
                thirdHelper.checked_drawable_bottom.mutate().setColorFilter(thirdHelper.checked_drawable_bottom_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.checked_drawable_bottom.mutate().clearColorFilter();
            }
            if (thirdHelper.normal_drawable_bottom_color != -1) {
                thirdHelper.normal_drawable_bottom.mutate().setColorFilter(thirdHelper.normal_drawable_bottom_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.normal_drawable_bottom.mutate().clearColorFilter();
            }
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(new int[]{0x10100A0}, thirdHelper.checked_drawable_bottom);
            stateListDrawable.addState(new int[0], thirdHelper.normal_drawable_bottom);
            int w = stateListDrawable.getIntrinsicWidth();
            int h = stateListDrawable.getIntrinsicHeight();
            stateListDrawable.setBounds(0, 0 - thirdHelper.padding_bottom, SetBackgroundUtil.getBottomWH(w, h, thirdHelper)[0], SetBackgroundUtil.getBottomWH(w, h, thirdHelper)[1] - thirdHelper.padding_bottom);
            myView.setCompoundDrawables(drawable0, drawable1, drawable2, (Drawable)stateListDrawable);
        } else {
            myView.setCompoundDrawables(drawable0, drawable1, drawable2, null);
        }
    }

    private static <T extends ThirdHelper> void setRightDrawable(CompoundButton myView, T thirdHelper) {
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        SetBackgroundUtil.setNullColorFilter(drawable0);
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        SetBackgroundUtil.setNullColorFilter(drawable1);
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        SetBackgroundUtil.setNullColorFilter(drawable3);
        if (thirdHelper.normal_drawable_right != null && thirdHelper.checked_drawable_right != null) {
            if (thirdHelper.checked_drawable_right_color != -1) {
                thirdHelper.checked_drawable_right.mutate().setColorFilter(thirdHelper.checked_drawable_right_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.checked_drawable_right.mutate().clearColorFilter();
            }
            if (thirdHelper.normal_drawable_right_color != -1) {
                thirdHelper.normal_drawable_right.mutate().setColorFilter(thirdHelper.normal_drawable_right_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.normal_drawable_right.mutate().clearColorFilter();
            }
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(new int[]{0x10100A0}, thirdHelper.checked_drawable_right);
            stateListDrawable.addState(new int[0], thirdHelper.normal_drawable_right);
            int w = stateListDrawable.getIntrinsicWidth();
            int h = stateListDrawable.getIntrinsicHeight();
            stateListDrawable.setBounds(0 - thirdHelper.padding_right, 0, SetBackgroundUtil.getRightWH(w, h, thirdHelper)[0] - thirdHelper.padding_right, SetBackgroundUtil.getRightWH(w, h, thirdHelper)[1]);
            myView.setCompoundDrawables(drawable0, drawable1, (Drawable)stateListDrawable, drawable3);
        } else {
            myView.setCompoundDrawables(drawable0, drawable1, null, drawable3);
        }
    }

    private static <T extends ThirdHelper> void setTopDrawable(CompoundButton myView, T thirdHelper) {
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        SetBackgroundUtil.setNullColorFilter(drawable0);
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        SetBackgroundUtil.setNullColorFilter(drawable2);
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        SetBackgroundUtil.setNullColorFilter(drawable3);
        if (thirdHelper.normal_drawable_top != null && thirdHelper.checked_drawable_top != null) {
            if (thirdHelper.checked_drawable_top_color != -1) {
                thirdHelper.checked_drawable_top.mutate().setColorFilter(thirdHelper.checked_drawable_top_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.checked_drawable_top.mutate().clearColorFilter();
            }
            if (thirdHelper.normal_drawable_top_color != -1) {
                thirdHelper.normal_drawable_top.mutate().setColorFilter(thirdHelper.normal_drawable_top_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.normal_drawable_top.mutate().clearColorFilter();
            }
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(new int[]{0x10100A0}, thirdHelper.checked_drawable_top);
            stateListDrawable.addState(new int[0], thirdHelper.normal_drawable_top);
            int w = stateListDrawable.getIntrinsicWidth();
            int h = stateListDrawable.getIntrinsicHeight();
            stateListDrawable.setBounds(0, thirdHelper.padding_top + 0, SetBackgroundUtil.getTopWH(w, h, thirdHelper)[0], thirdHelper.padding_top + SetBackgroundUtil.getTopWH(w, h, thirdHelper)[1]);
            myView.setCompoundDrawables(drawable0, (Drawable)stateListDrawable, drawable2, drawable3);
        } else {
            myView.setCompoundDrawables(drawable0, null, drawable2, drawable3);
        }
    }

    private static <T extends ThirdHelper> void setLeftDrawable(CompoundButton myView, T thirdHelper) {
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        SetBackgroundUtil.setNullColorFilter(drawable1);
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        SetBackgroundUtil.setNullColorFilter(drawable2);
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        SetBackgroundUtil.setNullColorFilter(drawable3);
        if (thirdHelper.normal_drawable_left != null && thirdHelper.checked_drawable_left != null) {
            if (thirdHelper.checked_drawable_left_color != -1) {
                thirdHelper.checked_drawable_left.mutate().setColorFilter(thirdHelper.checked_drawable_left_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.checked_drawable_left.mutate().clearColorFilter();
            }
            if (thirdHelper.normal_drawable_left_color != -1) {
                thirdHelper.normal_drawable_left.mutate().setColorFilter(thirdHelper.normal_drawable_left_color, thirdHelper.colorFilter);
            } else {
                thirdHelper.normal_drawable_left.mutate().clearColorFilter();
            }
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(new int[]{0x10100A0}, thirdHelper.checked_drawable_left);
            stateListDrawable.addState(new int[0], thirdHelper.normal_drawable_left);
            int w = stateListDrawable.getIntrinsicWidth();
            int h = stateListDrawable.getIntrinsicHeight();
            stateListDrawable.setBounds(thirdHelper.padding_left + 0, 0, thirdHelper.padding_left + SetBackgroundUtil.getLeftWH(w, h, thirdHelper)[0], SetBackgroundUtil.getLeftWH(w, h, thirdHelper)[1]);
            myView.setCompoundDrawables((Drawable)stateListDrawable, drawable1, drawable2, drawable3);
        } else {
            myView.setCompoundDrawables(null, drawable1, drawable2, drawable3);
        }
    }

    private static void setNullColorFilter(Drawable drawable2) {
        if (drawable2 != null) {
            // empty if block
        }
    }

    public static <T extends FirstHelper> void noPartBorderNoPressColor(View myView, T firstHelper) {
        GradientDrawable gradientDrawableNormal = SetBackgroundUtil.getNoPartBorderNoPressColorGradientDrawable(true, firstHelper);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)gradientDrawableNormal);
        } else {
            myView.setBackgroundDrawable((Drawable)gradientDrawableNormal);
        }
    }

    public static <T extends FirstHelper> void noPartBorderHasPressColor(View myView, T firstHelper) {
        GradientDrawable gradientDrawableNormal = SetBackgroundUtil.getNoPartBorderNoPressColorGradientDrawable(false, firstHelper);
        GradientDrawable gradientDrawablePress = SetBackgroundUtil.getNoPartBorderNoPressColorGradientDrawable(false, firstHelper);
        gradientDrawablePress.setColor(firstHelper.pressColor);
        StateListDrawable stateListDrawableForShape = new StateListDrawable();
        stateListDrawableForShape.addState(new int[]{-16842919}, (Drawable)gradientDrawableNormal);
        stateListDrawableForShape.addState(new int[]{16842919}, (Drawable)gradientDrawablePress);
        stateListDrawableForShape.addState(new int[0], (Drawable)gradientDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForShape);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForShape);
        }
    }

    public static <T extends FirstHelper> void hasPartBorderNoPressColor(View myView, T firstHelper) {
        SetBackgroundUtil.setBorderWidthForPartBorder(firstHelper);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)SetBackgroundUtil.getHasPartBorderNoPressColorLayerDrawableNormal(firstHelper));
        } else {
            myView.setBackgroundDrawable((Drawable)SetBackgroundUtil.getHasPartBorderNoPressColorLayerDrawableNormal(firstHelper));
        }
    }

    public static <T extends FirstHelper> void hasPartBorderHasPressColor(View myView, T firstHelper) {
        SetBackgroundUtil.setBorderWidthForPartBorder(firstHelper);
        GradientDrawable gradientDrawable = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawable(firstHelper);
        GradientDrawable gradientDrawableNormal = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawableNormal(firstHelper);
        GradientDrawable gradientDrawablePress = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawable(firstHelper);
        GradientDrawable gradientDrawableNormalPress = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawableNormal(firstHelper);
        gradientDrawableNormalPress.setColor(firstHelper.pressColor);
        LayerDrawable layerDrawableNormal = new LayerDrawable(new Drawable[]{gradientDrawable, gradientDrawableNormal});
        layerDrawableNormal.setLayerInset(1, firstHelper.partBorderWidth[0], firstHelper.partBorderWidth[1], firstHelper.partBorderWidth[2], firstHelper.partBorderWidth[3]);
        LayerDrawable layerDrawablePress = new LayerDrawable(new Drawable[]{gradientDrawablePress, gradientDrawableNormalPress});
        layerDrawablePress.setLayerInset(1, firstHelper.partBorderWidth[0], firstHelper.partBorderWidth[1], firstHelper.partBorderWidth[2], firstHelper.partBorderWidth[3]);
        StateListDrawable stateListDrawableForLayer = new StateListDrawable();
        stateListDrawableForLayer.addState(new int[]{-16842919}, (Drawable)layerDrawableNormal);
        stateListDrawableForLayer.addState(new int[]{16842919}, (Drawable)layerDrawablePress);
        stateListDrawableForLayer.addState(new int[0], (Drawable)layerDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForLayer);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
        }
    }

    public static <T extends FirstHelper> GradientDrawable getHasPartBorderNoPressColorGradientDrawable(T firstHelper) {
        GradientDrawable layerDrawable = new GradientDrawable();
        layerDrawable.setShape(firstHelper.shapeType);
        layerDrawable.setStroke((int)firstHelper.borderWidth, firstHelper.borderColor, firstHelper.borderDashWidth, firstHelper.borderDashGap);
        layerDrawable.setColor(firstHelper.solidColor);
        float[] fourRadius = new float[]{firstHelper.topLeftRadius, firstHelper.topLeftRadius, firstHelper.topRightRadius, firstHelper.topRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomLeftRadius, firstHelper.bottomLeftRadius};
        layerDrawable.setCornerRadii(fourRadius);
        return layerDrawable;
    }

    public static <T extends FirstHelper> GradientDrawable getHasPartBorderNoPressColorGradientDrawableNormal(T firstHelper) {
        GradientDrawable layerGradientDrawableNormal = new GradientDrawable();
        layerGradientDrawableNormal.setShape(firstHelper.shapeType);
        if (firstHelper.solidColor == SetBackgroundUtil.getTransparentColor()) {
            layerGradientDrawableNormal.setColor(Color.parseColor((String)"#ffffffff"));
        } else {
            layerGradientDrawableNormal.setColor(firstHelper.solidColor);
        }
        float[] fourRadius = new float[]{firstHelper.topLeftRadius, firstHelper.topLeftRadius, firstHelper.topRightRadius, firstHelper.topRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomLeftRadius, firstHelper.bottomLeftRadius};
        layerGradientDrawableNormal.setCornerRadii(fourRadius);
        return layerGradientDrawableNormal;
    }

    public static <T extends FirstHelper> LayerDrawable getHasPartBorderNoPressColorLayerDrawableNormal(T firstHelper) {
        GradientDrawable layerDrawable = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawable(firstHelper);
        GradientDrawable layerGradientDrawableNormal = SetBackgroundUtil.getHasPartBorderNoPressColorGradientDrawableNormal(firstHelper);
        Drawable[] layers = new Drawable[]{layerDrawable, layerGradientDrawableNormal};
        LayerDrawable layerDrawableNormal = new LayerDrawable(layers);
        layerDrawableNormal.setLayerInset(1, firstHelper.partBorderWidth[0], firstHelper.partBorderWidth[1], firstHelper.partBorderWidth[2], firstHelper.partBorderWidth[3]);
        return layerDrawableNormal;
    }

    protected static <T extends FirstHelper> void setBorderWidthForPartBorder(T firstHelper) {
        int[] partBorderWidth = new int[]{0, 0, 0, 0};
        if (firstHelper.left_line) {
            if (firstHelper.borderWidth == 0.0f) {
                firstHelper.borderWidth = 1.0f;
            }
            partBorderWidth[0] = (int)firstHelper.borderWidth;
            if (firstHelper.borderColor == SetBackgroundUtil.getTransparentColor()) {
                firstHelper.borderColor = SetBackgroundUtil.getDefBorderColor();
            }
        }
        if (firstHelper.top_line) {
            if (firstHelper.borderWidth == 0.0f) {
                firstHelper.borderWidth = 1.0f;
            }
            partBorderWidth[1] = (int)firstHelper.borderWidth;
            if (firstHelper.borderColor == SetBackgroundUtil.getTransparentColor()) {
                firstHelper.borderColor = SetBackgroundUtil.getDefBorderColor();
            }
        }
        if (firstHelper.right_line) {
            if (firstHelper.borderWidth == 0.0f) {
                firstHelper.borderWidth = 1.0f;
            }
            partBorderWidth[2] = (int)firstHelper.borderWidth;
            if (firstHelper.borderColor == SetBackgroundUtil.getTransparentColor()) {
                firstHelper.borderColor = SetBackgroundUtil.getDefBorderColor();
            }
        }
        if (firstHelper.bottom_line) {
            if (firstHelper.borderWidth == 0.0f) {
                firstHelper.borderWidth = 1.0f;
            }
            partBorderWidth[3] = (int)firstHelper.borderWidth;
            if (firstHelper.borderColor == SetBackgroundUtil.getTransparentColor()) {
                firstHelper.borderColor = SetBackgroundUtil.getDefBorderColor();
            }
        }
        firstHelper.partBorderWidth = partBorderWidth;
    }

    public static <T extends FirstHelper> GradientDrawable getNoPartBorderNoPressColorGradientDrawable(boolean isSetGradientType, T firstHelper) {
        GradientDrawable gradientDrawableNormal = new GradientDrawable();
        gradientDrawableNormal.setShape(firstHelper.shapeType);
        if (firstHelper.borderWidth > 0.0f && firstHelper.borderColor == 0) {
            firstHelper.borderColor = SetBackgroundUtil.getDefBorderColor();
        }
        gradientDrawableNormal.setStroke((int)firstHelper.borderWidth, firstHelper.borderColor, firstHelper.borderDashWidth, firstHelper.borderDashGap);
        gradientDrawableNormal.setColor(firstHelper.solidColor);
        float[] fourRadius = new float[]{firstHelper.topLeftRadius, firstHelper.topLeftRadius, firstHelper.topRightRadius, firstHelper.topRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomRightRadius, firstHelper.bottomLeftRadius, firstHelper.bottomLeftRadius};
        gradientDrawableNormal.setCornerRadii(fourRadius);
        if (isSetGradientType) {
            SetBackgroundUtil.setDrawableGradientType(gradientDrawableNormal, firstHelper);
        }
        return gradientDrawableNormal;
    }

    public static <T extends FirstHelper> void setDrawableGradientType(GradientDrawable gradientDrawableNormal, T firstHelper) {
        if (firstHelper.gradientType != -1) {
            gradientDrawableNormal.setGradientCenter(firstHelper.gradientCenterX, firstHelper.gradientCenterY);
            if (Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setOrientation(SetBackgroundUtil.getViewOrientation(firstHelper.gradientAngle));
            }
            if (firstHelper.gradientCenterColor != 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    gradientDrawableNormal.setColors(new int[]{firstHelper.gradientStartColor, firstHelper.gradientCenterColor, firstHelper.gradientEndColor});
                }
            } else if ((firstHelper.gradientStartColor != 0 || firstHelper.gradientEndColor != 0) && Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setColors(new int[]{firstHelper.gradientStartColor, firstHelper.gradientEndColor});
            }
            if (firstHelper.gradientType == 1) {
                gradientDrawableNormal.setGradientRadius(firstHelper.gradientRadius);
                gradientDrawableNormal.setUseLevel(false);
            }
            gradientDrawableNormal.setGradientType(firstHelper.gradientType);
        }
    }

    public static GradientDrawable.Orientation getViewOrientation(int angle) {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        switch (angle) {
            case 0: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    protected static <T extends SecondHelper> int[] getLeftWH(int width, int height, T secondHelper) {
        if (secondHelper.left_width > 0 && secondHelper.left_height > 0) {
            return new int[]{secondHelper.left_width, secondHelper.left_height};
        }
        if (secondHelper.left_width > 0) {
            return new int[]{secondHelper.left_width, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.left_width, height), width)};
        }
        if (secondHelper.left_height > 0) {
            return new int[]{secondHelper.left_height, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.left_height, width), height)};
        }
        return new int[]{width, height};
    }

    protected static <T extends SecondHelper> int[] getTopWH(int width, int height, T secondHelper) {
        if (secondHelper.top_width > 0 && secondHelper.top_height > 0) {
            return new int[]{secondHelper.top_width, secondHelper.top_height};
        }
        if (secondHelper.top_width > 0) {
            return new int[]{secondHelper.top_width, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.top_width, height), width)};
        }
        if (secondHelper.top_height > 0) {
            return new int[]{secondHelper.top_height, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.top_height, width), height)};
        }
        return new int[]{width, height};
    }

    protected static <T extends SecondHelper> int[] getRightWH(int width, int height, T secondHelper) {
        if (secondHelper.right_width > 0 && secondHelper.right_height > 0) {
            return new int[]{secondHelper.right_width, secondHelper.right_height};
        }
        if (secondHelper.right_width > 0) {
            return new int[]{secondHelper.right_width, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.right_width, height), width)};
        }
        if (secondHelper.right_height > 0) {
            return new int[]{secondHelper.right_height, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.right_height, width), height)};
        }
        return new int[]{width, height};
    }

    protected static <T extends SecondHelper> int[] getBottomWH(int width, int height, T secondHelper) {
        if (secondHelper.bottom_width > 0 && secondHelper.bottom_height > 0) {
            return new int[]{secondHelper.bottom_width, secondHelper.bottom_height};
        }
        if (secondHelper.bottom_width > 0) {
            return new int[]{secondHelper.bottom_width, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.bottom_width, height), width)};
        }
        if (secondHelper.bottom_height > 0) {
            return new int[]{secondHelper.bottom_height, (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(secondHelper.bottom_height, width), height)};
        }
        return new int[]{width, height};
    }

    public static double chuFa(double d1, double d2) {
        return SetBackgroundUtil.chuFa(d1, d2, 2);
    }

    private static double chuFa(double d1, double d2, int scale) {
        try {
            if (d2 == 0.0) {
                throw new Exception("\u5206\u6bcd\u4e0d\u80fd\u4e3a0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return bd1.divide(bd2, scale, 4).doubleValue();
    }

    public static double chengFa(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(d1);
        BigDecimal bd2 = new BigDecimal(d2);
        return SetBackgroundUtil.round(bd1.multiply(bd2).doubleValue());
    }

    protected static double round(double value) {
        return SetBackgroundUtil.round(value, 2, 4);
    }

    protected static double round(double value, int scale, int roundingMode) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(scale, roundingMode);
        double d = bd.doubleValue();
        bd = null;
        return d;
    }

    protected static int getDefBorderColor() {
        return Color.parseColor((String)"#E2E2E2");
    }

    protected static int getTransparentColor() {
        return 0;
    }
}

