/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.github.fastshape.R;
import com.github.fastshape.inter.CompleteInter;
import com.github.fastshape.viewhelper.FourthHelper;
import com.github.fastshape.viewhelper.SetBackgroundUtil;

public class MyEditText
extends AppCompatEditText {
    public boolean focusFlag;
    private boolean hiddenClearIcon;
    protected Drawable clearIconDrawable;
    protected int clearIcon_width;
    protected int clearIcon_height;
    public OnRightListener onRightListener;
    private FourthHelper viewHelper;

    public MyEditText(Context context) {
        super(context);
        this.initHelper(null);
    }

    public MyEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHelper(attrs);
    }

    public MyEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initHelper(attrs);
    }

    private void initHelper(AttributeSet attrs) {
        this.viewHelper = new FourthHelper(new CompleteInter(){

            @Override
            public void complete() {
                MyEditText.this.complete();
            }

            @Override
            public void completeClip() {
            }

            @Override
            public void resetClip() {
            }
        });
        this.init(attrs);
    }

    public FourthHelper getViewHelper() {
        return this.viewHelper;
    }

    public void init(AttributeSet attrs) {
        TypedArray typedArray = this.viewHelper.initCompat(this.getContext(), attrs, R.attr.MyEditTextStyle);
        this.clearIconDrawable = typedArray.getDrawable(R.styleable.FastShapeAttr_clearIconDrawable);
        this.hiddenClearIcon = typedArray.getBoolean(R.styleable.FastShapeAttr_hiddenClearIcon, false);
        this.clearIcon_width = (int)typedArray.getDimension(R.styleable.FastShapeAttr_clearIcon_width, 0.0f);
        this.clearIcon_height = (int)typedArray.getDimension(R.styleable.FastShapeAttr_clearIcon_height, 0.0f);
        typedArray.recycle();
        this.setClearIconDrawable(this.clearIconDrawable);
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                MyEditText.this.focusFlag = hasFocus;
                if (hasFocus) {
                    MyEditText.this.setClearIconVisible(MyEditText.this.getText().length() > 0);
                } else {
                    MyEditText.this.setClearIconVisible(false);
                }
            }
        });
        this.addTextChangedListener(this.getWatcher());
        Drawable background = this.getBackground();
        if (background instanceof ColorDrawable && background != null) {
            SetBackgroundUtil.setCompoundDrawables((TextView)this, this.viewHelper);
        } else {
            this.complete();
        }
    }

    public void complete() {
        if (this.viewHelper != null) {
            SetBackgroundUtil.viewComplete((View)this, this.viewHelper);
            SetBackgroundUtil.setCompoundDrawables((TextView)this, this.viewHelper);
        }
    }

    public void setOnRightListener(OnRightListener onRightListener) {
        this.onRightListener = onRightListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.getCompoundDrawables()[2] != null) {
            boolean touchable;
            boolean bl = touchable = event.getX() > (float)(this.getWidth() - this.getTotalPaddingRight()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchable && (this.onRightListener == null || !this.onRightListener.clickRight())) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    private void setClearIconVisible(boolean visible) {
        Drawable right = visible && !this.hiddenClearIcon ? this.clearIconDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            try {
                this.setSelection(text.length());
            }
            catch (Exception e) {
                Log.e((String)"Exception", (String)"\u8f93\u5165\u5b57\u7b26\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
            }
        }
    }

    public MyEditText setHiddenClearIcon(boolean isHiddenClear) {
        this.hiddenClearIcon = isHiddenClear;
        return this;
    }

    public boolean isHiddenClearIcon() {
        return this.hiddenClearIcon;
    }

    public Drawable getClearIconDrawable() {
        return this.clearIconDrawable;
    }

    public int getClearIcon_width() {
        return this.clearIcon_width;
    }

    public MyEditText setClearIcon_width(int clearIcon_width) {
        this.clearIcon_width = clearIcon_width;
        if (this.clearIconDrawable != null) {
            this.refreshIconBounds(this.clearIcon_width, this.clearIcon_height);
        }
        return this;
    }

    public int getClearIcon_height() {
        return this.clearIcon_height;
    }

    public MyEditText setClearIcon_height(int clearIcon_height) {
        this.clearIcon_height = clearIcon_height;
        if (this.clearIconDrawable != null) {
            this.refreshIconBounds(this.clearIcon_width, this.clearIcon_height);
        }
        return this;
    }

    public MyEditText setClearIconDrawable(@DrawableRes int clearDrawable) {
        return this.setClearIconDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)clearDrawable));
    }

    public MyEditText setClearIconDrawable(Drawable clearIcon) {
        this.clearIconDrawable = clearIcon != null ? clearIcon : this.getCompoundDrawables()[2];
        if (this.clearIconDrawable == null) {
            this.clearIconDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.textclear);
        }
        this.refreshIconBounds(this.getClearIcon_width(), this.getClearIcon_height());
        return this;
    }

    private void refreshIconBounds(int clearIcon_width, int clearIcon_height) {
        int width = this.clearIconDrawable.getIntrinsicWidth();
        int height = this.clearIconDrawable.getIntrinsicHeight();
        int w = clearIcon_width;
        int h = clearIcon_height;
        if (w <= 0 || h <= 0) {
            if (w > 0) {
                h = (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(w, height), width);
            } else if (h > 0) {
                w = (int)SetBackgroundUtil.chuFa(SetBackgroundUtil.chengFa(h, width), height);
            } else {
                w = width;
                h = height;
            }
        }
        this.clearIconDrawable.setBounds(0, 0, w, h);
    }

    private TextWatcher getWatcher() {
        return new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (MyEditText.this.focusFlag) {
                    MyEditText.this.setClearIconVisible(s.length() > 0);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        };
    }

    public static interface OnRightListener {
        public boolean clickRight();
    }
}

