/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.github.fastshape.BaseViewHelper;
import com.github.fastshape.R;
import com.github.fastshape.inter.ViewHelperInter;

public class MyEditText
extends AppCompatEditText
implements View.OnFocusChangeListener {
    private BaseViewHelper viewHelper;
    private Drawable mClearDrawable;
    private boolean hasFoucs;
    private boolean isHiddenClear;
    public OnRightListener onRightListener;
    private int clearIcon_width;
    private int clearIcon_height;

    public void setOnRightListener(OnRightListener onRightListener) {
        this.onRightListener = onRightListener;
    }

    public MyEditText(Context context) {
        super(context);
        this.init(null);
    }

    public MyEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MyEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public BaseViewHelper getViewHelper() {
        return this.viewHelper;
    }

    public void setViewHelper(BaseViewHelper viewHelper) {
        this.viewHelper = viewHelper;
    }

    private void init(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        this.viewHelper = new BaseViewHelper(new ViewHelperInter(){

            @Override
            public void onComplete() {
                MyEditText.this.complete();
            }
        });
        Drawable background = this.getBackground();
        if (background instanceof ColorDrawable && background != null) {
            return;
        }
        TypedArray viewNormal = this.getContext().obtainStyledAttributes(attrs, R.styleable.MyEditText);
        Drawable drawable_normal = viewNormal.getDrawable(R.styleable.MyEditText_drawable_normal);
        Drawable drawable_press = viewNormal.getDrawable(R.styleable.MyEditText_drawable_press);
        this.clearIcon_width = (int)viewNormal.getDimension(R.styleable.MyEditText_clearIcon_width, -1.0f);
        this.clearIcon_height = (int)viewNormal.getDimension(R.styleable.MyEditText_clearIcon_height, -1.0f);
        this.isHiddenClear = viewNormal.getBoolean(R.styleable.MyEditText_hiddenClearIcon, false);
        Drawable clearIcon = viewNormal.getDrawable(R.styleable.MyEditText_clearIconDrawable);
        this.setRightDrawble(clearIcon);
        if (drawable_normal != null || drawable_press != null) {
            this.viewHelper.drawable_normal = drawable_normal;
            this.viewHelper.drawable_press = drawable_press;
            if (drawable_normal == null) {
                this.viewHelper.drawable_normal = drawable_press;
            }
            if (drawable_press == null) {
                this.viewHelper.drawable_press = drawable_normal;
            }
            viewNormal.recycle();
            this.complete();
            return;
        }
        this.viewHelper.pressColor = viewNormal.getColor(R.styleable.MyEditText_pressColor, this.viewHelper.getTransparentColor());
        this.viewHelper.allLine = viewNormal.getBoolean(R.styleable.MyEditText_all_line, false);
        this.viewHelper.leftLine = viewNormal.getBoolean(R.styleable.MyEditText_left_line, false);
        this.viewHelper.topLine = viewNormal.getBoolean(R.styleable.MyEditText_top_line, false);
        this.viewHelper.rightLine = viewNormal.getBoolean(R.styleable.MyEditText_right_line, false);
        this.viewHelper.bottomLine = viewNormal.getBoolean(R.styleable.MyEditText_bottom_line, false);
        if (this.viewHelper.leftLine && this.viewHelper.topLine && this.viewHelper.rightLine && this.viewHelper.bottomLine) {
            this.viewHelper.allLine = true;
        }
        if (!this.viewHelper.allLine && (this.viewHelper.leftLine || this.viewHelper.topLine || this.viewHelper.rightLine || this.viewHelper.bottomLine)) {
            this.viewHelper.isPartBorder = true;
        }
        this.viewHelper.shapeType = viewNormal.getInteger(R.styleable.MyEditText_shapeType, 0);
        this.viewHelper.borderWidth = viewNormal.getDimension(R.styleable.MyEditText_borderWidth, 0.0f);
        this.viewHelper.borderColor = viewNormal.getColor(R.styleable.MyEditText_borderColor, this.viewHelper.getTransparentColor());
        this.viewHelper.borderDashWidth = viewNormal.getDimension(R.styleable.MyEditText_borderDashWidth, 0.0f);
        this.viewHelper.borderDashGap = viewNormal.getDimension(R.styleable.MyEditText_borderDashGap, 0.0f);
        this.viewHelper.solidColor = viewNormal.getColor(R.styleable.MyEditText_solidColor, this.viewHelper.getTransparentColor());
        float radius = viewNormal.getDimension(R.styleable.MyEditText_radius, 0.0f);
        if (radius > 0.0f) {
            this.viewHelper.topLeftRadius = radius;
            this.viewHelper.topRightRadius = radius;
            this.viewHelper.bottomLeftRadius = radius;
            this.viewHelper.bottomRightRadius = radius;
        } else {
            this.viewHelper.topLeftRadius = viewNormal.getDimension(R.styleable.MyEditText_topLeftRadius, 0.0f);
            this.viewHelper.topRightRadius = viewNormal.getDimension(R.styleable.MyEditText_topRightRadius, 0.0f);
            this.viewHelper.bottomLeftRadius = viewNormal.getDimension(R.styleable.MyEditText_bottomLeftRadius, 0.0f);
            this.viewHelper.bottomRightRadius = viewNormal.getDimension(R.styleable.MyEditText_bottomRightRadius, 0.0f);
        }
        this.viewHelper.gradientType = viewNormal.getInteger(R.styleable.MyEditText_gradientType, -1);
        if (this.viewHelper.gradientType != -1) {
            this.viewHelper.angle = viewNormal.getInteger(R.styleable.MyEditText_gradientAngle, 0);
            this.viewHelper.centerX = viewNormal.getFloat(R.styleable.MyEditText_gradientCenterX, 0.5f);
            this.viewHelper.centerY = viewNormal.getFloat(R.styleable.MyEditText_gradientCenterY, 0.5f);
            this.viewHelper.startColor = viewNormal.getColor(R.styleable.MyEditText_gradientStartColor, 0);
            this.viewHelper.centerColor = viewNormal.getColor(R.styleable.MyEditText_gradientCenterColor, 0);
            this.viewHelper.endColor = viewNormal.getColor(R.styleable.MyEditText_gradientEndColor, 0);
            this.viewHelper.gradientRadius = viewNormal.getDimension(R.styleable.MyEditText_gradientRadius, 40.0f);
        }
        viewNormal.recycle();
        this.complete();
    }

    public void complete() {
        this.viewHelper.viewComplete((View)this);
    }

    public void setClearDrawable(Drawable clearDrawable) {
        this.setRightDrawble(clearDrawable);
    }

    public void setClearDrawable(@DrawableRes int clearDrawable) {
        this.setClearDrawable(this.getResources().getDrawable(clearDrawable));
    }

    public void setHiddenClearIcon(boolean isHiddenClear) {
        this.isHiddenClear = isHiddenClear;
    }

    private void setRightDrawble(Drawable clearIcon) {
        if (this.isInEditMode()) {
            return;
        }
        this.mClearDrawable = clearIcon != null ? clearIcon : this.getCompoundDrawables()[2];
        if (this.mClearDrawable == null) {
            this.mClearDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.textclear);
        }
        int width = this.mClearDrawable.getIntrinsicWidth();
        int height = this.mClearDrawable.getIntrinsicHeight();
        int w = this.mClearDrawable.getIntrinsicWidth();
        int h = this.mClearDrawable.getIntrinsicHeight();
        if (this.clearIcon_width != -1 && this.clearIcon_height != -1) {
            w = this.clearIcon_width;
            h = this.clearIcon_height;
        } else if (this.clearIcon_width != -1) {
            w = this.clearIcon_width;
            h = (int)this.viewHelper.chuFa(this.viewHelper.chengFa(this.clearIcon_width, height), width);
        } else if (this.clearIcon_height != -1) {
            w = this.clearIcon_height;
            h = (int)this.viewHelper.chuFa(this.viewHelper.chengFa(this.clearIcon_height, width), height);
        }
        this.mClearDrawable.setBounds(0, 0, w, h);
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this.getWatcher());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.getCompoundDrawables()[2] != null) {
            boolean touchable;
            boolean bl = touchable = event.getX() > (float)(this.getWidth() - this.getTotalPaddingRight()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchable && (this.onRightListener == null || !this.onRightListener.clickRight())) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    protected void setClearIconVisible(boolean visible) {
        Drawable right = visible && !this.isHiddenClear ? this.mClearDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            try {
                this.setSelection(text.length());
            }
            catch (Exception e) {
                Log.e((String)"Exception", (String)"\u8f93\u5165\u5b57\u7b26\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
            }
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        this.hasFoucs = hasFocus;
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    private TextWatcher getWatcher() {
        return new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (MyEditText.this.hasFoucs) {
                    MyEditText.this.setClearIconVisible(s.length() > 0);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        };
    }

    private int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static interface OnRightListener {
        public boolean clickRight();
    }
}

