/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.github.fastshape.BaseViewHelper;
import com.github.fastshape.R;
import com.github.fastshape.inter.ViewHelperInter;

public class MyRelativeLayout
extends RelativeLayout {
    private BaseViewHelper viewHelper;

    public MyRelativeLayout(Context context) {
        super(context);
        this.init(null);
    }

    public MyRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MyRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public MyRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public BaseViewHelper getViewHelper() {
        return this.viewHelper;
    }

    public void setViewHelper(BaseViewHelper viewHelper) {
        this.viewHelper = viewHelper;
    }

    private void init(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        this.viewHelper = new BaseViewHelper(new ViewHelperInter(){

            @Override
            public void onComplete() {
                MyRelativeLayout.this.complete();
            }
        });
        Drawable background = this.getBackground();
        if (background != null) {
            return;
        }
        TypedArray viewNormal = this.getContext().obtainStyledAttributes(attrs, R.styleable.MyRelativeLayout);
        Drawable drawable_normal = viewNormal.getDrawable(R.styleable.MyRelativeLayout_drawable_normal);
        Drawable drawable_press = viewNormal.getDrawable(R.styleable.MyRelativeLayout_drawable_press);
        if (drawable_normal != null || drawable_press != null) {
            this.viewHelper.drawable_normal = drawable_normal;
            this.viewHelper.drawable_press = drawable_press;
            if (drawable_normal == null) {
                this.viewHelper.drawable_normal = drawable_press;
            }
            if (drawable_press == null) {
                this.viewHelper.drawable_press = drawable_normal;
            }
            viewNormal.recycle();
            this.complete();
            return;
        }
        this.viewHelper.pressColor = viewNormal.getColor(R.styleable.MyRelativeLayout_pressColor, this.viewHelper.getTransparentColor());
        this.viewHelper.allLine = viewNormal.getBoolean(R.styleable.MyRelativeLayout_all_line, false);
        this.viewHelper.leftLine = viewNormal.getBoolean(R.styleable.MyRelativeLayout_left_line, false);
        this.viewHelper.topLine = viewNormal.getBoolean(R.styleable.MyRelativeLayout_top_line, false);
        this.viewHelper.rightLine = viewNormal.getBoolean(R.styleable.MyRelativeLayout_right_line, false);
        this.viewHelper.bottomLine = viewNormal.getBoolean(R.styleable.MyRelativeLayout_bottom_line, false);
        if (this.viewHelper.leftLine && this.viewHelper.topLine && this.viewHelper.rightLine && this.viewHelper.bottomLine) {
            this.viewHelper.allLine = true;
        }
        if (!this.viewHelper.allLine && (this.viewHelper.leftLine || this.viewHelper.topLine || this.viewHelper.rightLine || this.viewHelper.bottomLine)) {
            this.viewHelper.isPartBorder = true;
        }
        this.viewHelper.shapeType = viewNormal.getInteger(R.styleable.MyRelativeLayout_shapeType, 0);
        this.viewHelper.borderWidth = viewNormal.getDimension(R.styleable.MyRelativeLayout_borderWidth, 0.0f);
        this.viewHelper.borderColor = viewNormal.getColor(R.styleable.MyRelativeLayout_borderColor, this.viewHelper.getTransparentColor());
        this.viewHelper.borderDashWidth = viewNormal.getDimension(R.styleable.MyRelativeLayout_borderDashWidth, 0.0f);
        this.viewHelper.borderDashGap = viewNormal.getDimension(R.styleable.MyRelativeLayout_borderDashGap, 0.0f);
        this.viewHelper.solidColor = viewNormal.getColor(R.styleable.MyRelativeLayout_solidColor, this.viewHelper.getTransparentColor());
        this.viewHelper.radius = viewNormal.getDimension(R.styleable.MyRelativeLayout_radius, 0.0f);
        if (this.viewHelper.radius <= 0.0f) {
            this.viewHelper.topLeftRadius = viewNormal.getDimension(R.styleable.MyRelativeLayout_topLeftRadius, 0.0f);
            this.viewHelper.topRightRadius = viewNormal.getDimension(R.styleable.MyRelativeLayout_topRightRadius, 0.0f);
            this.viewHelper.bottomLeftRadius = viewNormal.getDimension(R.styleable.MyRelativeLayout_bottomLeftRadius, 0.0f);
            this.viewHelper.bottomRightRadius = viewNormal.getDimension(R.styleable.MyRelativeLayout_bottomRightRadius, 0.0f);
        }
        this.viewHelper.gradientType = viewNormal.getInteger(R.styleable.MyRelativeLayout_gradientType, -1);
        if (this.viewHelper.gradientType != -1) {
            this.viewHelper.angle = viewNormal.getInteger(R.styleable.MyRelativeLayout_gradientAngle, 0);
            this.viewHelper.centerX = viewNormal.getFloat(R.styleable.MyRelativeLayout_gradientCenterX, 0.5f);
            this.viewHelper.centerY = viewNormal.getFloat(R.styleable.MyRelativeLayout_gradientCenterY, 0.5f);
            this.viewHelper.startColor = viewNormal.getColor(R.styleable.MyRelativeLayout_gradientStartColor, 0);
            this.viewHelper.centerColor = viewNormal.getColor(R.styleable.MyRelativeLayout_gradientCenterColor, 0);
            this.viewHelper.endColor = viewNormal.getColor(R.styleable.MyRelativeLayout_gradientEndColor, 0);
            this.viewHelper.gradientRadius = viewNormal.getDimension(R.styleable.MyRelativeLayout_gradientRadius, 40.0f);
        }
        viewNormal.recycle();
        this.complete();
    }

    public void complete() {
        this.viewHelper.viewComplete((View)this);
    }
}

