/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.github.fastshape.R;

public class MyImageView
extends AppCompatImageView {
    private Paint paint;
    private Paint paintView;
    private float radius;
    private float topLeftRadius;
    private float topRightRadius;
    private float bottomLeftRadius;
    private float bottomRightRadius;

    public MyImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public MyImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MyImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray viewNormal = context.obtainStyledAttributes(attrs, R.styleable.MyImageView);
        this.radius = viewNormal.getDimension(R.styleable.MyImageView_radius, 0.0f);
        this.bottomRightRadius = viewNormal.getDimension(R.styleable.MyImageView_bottomRightRadius, 0.0f);
        this.bottomLeftRadius = viewNormal.getDimension(R.styleable.MyImageView_bottomLeftRadius, 0.0f);
        this.topRightRadius = viewNormal.getDimension(R.styleable.MyImageView_topRightRadius, 0.0f);
        this.topLeftRadius = viewNormal.getDimension(R.styleable.MyImageView_topLeftRadius, 0.0f);
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.paintView = new Paint();
        this.paintView.setXfermode(null);
    }

    public MyImageView setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public MyImageView setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public MyImageView setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
        return this;
    }

    public MyImageView setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    public MyImageView setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public void complete() {
        this.invalidate();
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvasRadius = new Canvas(bitmap);
        super.draw(canvasRadius);
        if (this.radius > 0.0f) {
            this.drawLiftUp(canvasRadius, this.radius);
            this.drawLiftDown(canvasRadius, this.radius);
            this.drawRightUp(canvasRadius, this.radius);
            this.drawRightDown(canvasRadius, this.radius);
        } else {
            this.drawLiftUp(canvasRadius, this.topLeftRadius);
            this.drawLiftDown(canvasRadius, this.bottomLeftRadius);
            this.drawRightUp(canvasRadius, this.topRightRadius);
            this.drawRightDown(canvasRadius, this.bottomRightRadius);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paintView);
        bitmap.recycle();
    }

    private void drawLiftUp(Canvas canvas, float radius) {
        Path path = new Path();
        path.moveTo(0.0f, radius);
        path.lineTo(0.0f, 0.0f);
        path.lineTo(radius, 0.0f);
        path.arcTo(new RectF(0.0f, 0.0f, radius * 2.0f, radius * 2.0f), -90.0f, -90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawLiftDown(Canvas canvas, float radius) {
        Path path = new Path();
        path.moveTo(0.0f, (float)this.getHeight() - radius);
        path.lineTo(0.0f, (float)this.getHeight());
        path.lineTo(radius, (float)this.getHeight());
        path.arcTo(new RectF(0.0f, (float)this.getHeight() - radius * 2.0f, radius * 2.0f, (float)this.getHeight()), 90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightDown(Canvas canvas, float radius) {
        Path path = new Path();
        path.moveTo((float)this.getWidth() - radius, (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)this.getHeight() - radius);
        path.arcTo(new RectF((float)this.getWidth() - radius * 2.0f, (float)this.getHeight() - radius * 2.0f, (float)this.getWidth(), (float)this.getHeight()), 0.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightUp(Canvas canvas, float radius) {
        Path path = new Path();
        path.moveTo((float)this.getWidth(), radius);
        path.lineTo((float)this.getWidth(), 0.0f);
        path.lineTo((float)this.getWidth() - radius, 0.0f);
        path.arcTo(new RectF((float)this.getWidth() - radius * 2.0f, 0.0f, (float)this.getWidth(), 0.0f + radius * 2.0f), -90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }
}

