/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.internal.objenesis.ObjenesisStd;
import com.mongodb.DB;
import com.mongodb.FongoMongoDatabase;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.BufferProvider;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.operation.OperationExecutor;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MockMongoClient
extends MongoClient {
    private static final MongoClientOptions clientOptions = MongoClientOptions.builder().build();
    private volatile BufferProvider bufferProvider;
    private Fongo fongo;
    private MongoOptions options;
    private ReadConcern readConcern;

    public static MockMongoClient create(Fongo fongo) {
        MockMongoClient client = new ObjenesisStd().getInstantiatorOf(MockMongoClient.class).newInstance();
        client.options = new MongoOptions(clientOptions);
        client.fongo = fongo;
        client.setWriteConcern(clientOptions.getWriteConcern());
        client.setReadPreference(clientOptions.getReadPreference());
        client.readConcern = clientOptions.getReadConcern() == null ? ReadConcern.DEFAULT : clientOptions.getReadConcern();
        return client;
    }

    public String toString() {
        return this.fongo.toString();
    }

    public Collection<DB> getUsedDatabases() {
        return this.fongo.getUsedDatabases();
    }

    public List<String> getDatabaseNames() {
        return this.fongo.getDatabaseNames();
    }

    public int getMaxBsonObjectSize() {
        return 0x1000000;
    }

    public DB getDB(String dbname) {
        return this.fongo.getDB(dbname);
    }

    public MongoDatabase getDatabase(String databaseName) {
        return new FongoMongoDatabase(databaseName, this.fongo);
    }

    public void dropDatabase(String dbName) {
        this.fongo.dropDatabase(dbName);
    }

    public MongoOptions getMongoOptions() {
        return this.options;
    }

    public MongoClientOptions getMongoClientOptions() {
        return clientOptions;
    }

    public List<ServerAddress> getAllAddress() {
        return super.getAllAddress();
    }

    public List<ServerAddress> getServerAddressList() {
        return Collections.singletonList(this.fongo.getServerAddress());
    }

    OperationExecutor createOperationExecutor() {
        return this.fongo;
    }

    public void close() {
    }

    synchronized BufferProvider getBufferProvider() {
        if (this.bufferProvider == null) {
            this.bufferProvider = new PowerOfTwoBufferPool();
        }
        return this.bufferProvider;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }
}

