/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.impl.Util;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.FongoDBCollection;
import com.mongodb.client.model.FindOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoDBCursor
extends DBCursor {
    private static final Logger LOG = LoggerFactory.getLogger(FongoDBCursor.class);
    private final FongoDBCollection dbCollection;
    private final DBObject query;
    private final DBObject projection;
    private final FindOptions findOptions;
    private final DBObject modifiers;
    private DBObject sort;
    private int numSeen;
    private boolean closed;
    private DBObject currentObject;
    private List<DBObject> objects = null;
    private Iterator<DBObject> iterator;

    public FongoDBCursor(FongoDBCollection fongoDBCollection, DBObject query, DBObject projection) {
        this(fongoDBCollection, query, projection, new FindOptions(), (DBObject)new BasicDBObject(), null);
    }

    private FongoDBCursor(FongoDBCollection collection, DBObject query, DBObject projection, FindOptions findOptions, DBObject modifiers, DBObject sort) {
        super((DBCollection)collection, query, projection, collection.getReadPreference());
        this.dbCollection = collection;
        this.query = query;
        this.projection = projection;
        this.findOptions = findOptions;
        this.modifiers = modifiers;
        this.sort = sort;
    }

    private void fetch() {
        if (this.objects == null) {
            this.objects = new ArrayList<DBObject>();
            Object q = this.query != null && this.query.containsField("$query") ? Util.clone(this.query) : new BasicDBObject("$query", (Object)Util.clone(this.query));
            if (this.sort != null) {
                q.put("$orderby", (Object)this.sort);
            }
            q.putAll((BSONObject)this.modifiers);
            this.objects.addAll(this.dbCollection.__find((DBObject)q, this.projection, this.findOptions.getSkip(), this.findOptions.getBatchSize(), this.getLimit(), this.getOptions(), this.getReadPreference(), null));
            this.iterator = this.objects.iterator();
        }
    }

    private DBObject currentObject(DBObject newCurrentObject) {
        if (newCurrentObject != null) {
            this.currentObject = newCurrentObject;
            ++this.numSeen;
            if (this.projection != null && !this.projection.keySet().isEmpty()) {
                this.currentObject.markAsPartialObject();
            }
        }
        return newCurrentObject;
    }

    public synchronized List<DBObject> toArray(int max) {
        this.fetch();
        return this.objects;
    }

    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        this.fetch();
        return this.iterator.hasNext();
    }

    public DBObject next() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        this.fetch();
        ++this.numSeen;
        return this.currentObject(this.iterator.next());
    }

    public DBObject tryNext() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        return this.next();
    }

    public DBObject curr() {
        return this.currentObject;
    }

    public int length() {
        return this.objects.size();
    }

    public DBCursor copy() {
        return new FongoDBCursor(this.dbCollection, this.query, this.projection, new FindOptions(this.findOptions), Util.clone(this.modifiers), Util.clone(this.sort));
    }

    public int getLimit() {
        return this.findOptions.getLimit();
    }

    public int getBatchSize() {
        return this.findOptions.getBatchSize();
    }

    public DBCursor comment(String comment) {
        return super.comment(comment);
    }

    public DBCursor maxScan(int max) {
        this.modifiers.put("$maxScan", (Object)max);
        return super.maxScan(max);
    }

    public DBCursor max(DBObject max) {
        this.modifiers.put("$max", (Object)max);
        return super.max(max);
    }

    public DBCursor min(DBObject min) {
        this.modifiers.put("$min", (Object)min);
        return super.min(min);
    }

    public DBCursor returnKey() {
        this.modifiers.put("$returnKey", (Object)true);
        return super.returnKey();
    }

    public DBCursor maxTime(long maxTime, TimeUnit timeUnit) {
        this.findOptions.maxTime(maxTime, timeUnit);
        return super.maxTime(maxTime, timeUnit);
    }

    public DBCursor snapshot() {
        this.modifiers.put("$snapshot", (Object)true);
        return super.snapshot();
    }

    public DBCursor sort(DBObject orderBy) {
        this.sort = orderBy;
        return super.sort(orderBy);
    }

    public DBCursor limit(int limit) {
        this.findOptions.limit(limit);
        return super.limit(limit);
    }

    public DBCursor batchSize(int numberOfElements) {
        this.findOptions.batchSize(numberOfElements);
        return super.batchSize(numberOfElements);
    }

    public DBCursor skip(int numberOfElements) {
        this.findOptions.skip(numberOfElements);
        return super.skip(numberOfElements);
    }

    public long getCursorId() {
        return super.getCursorId();
    }

    public int numSeen() {
        return this.numSeen;
    }

    public void close() {
        this.closed = true;
        super.close();
    }

    public DBCursor slaveOk() {
        return super.slaveOk();
    }

    public int count() {
        return super.count();
    }

    public DBObject one() {
        return super.one();
    }

    public int itcount() {
        return super.itcount();
    }

    public int size() {
        return super.size();
    }
}

