/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.impl.aggregation.Group;
import com.github.fakemongo.impl.aggregation.Limit;
import com.github.fakemongo.impl.aggregation.Match;
import com.github.fakemongo.impl.aggregation.Out;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.github.fakemongo.impl.aggregation.Project;
import com.github.fakemongo.impl.aggregation.Skip;
import com.github.fakemongo.impl.aggregation.Sort;
import com.github.fakemongo.impl.aggregation.Unwind;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator {
    private static final Logger LOG = LoggerFactory.getLogger(Aggregator.class);
    private final FongoDB fongoDB;
    private final FongoDBCollection fongoDBCollection;
    private final List<? extends DBObject> pipeline;
    private static final List<PipelineKeyword> keywords = Arrays.asList(Match.INSTANCE, Project.INSTANCE, Group.INSTANCE, Sort.INSTANCE, Limit.INSTANCE, Skip.INSTANCE, Unwind.INSTANCE, Out.INSTANCE);

    public Aggregator(FongoDB fongoDB, FongoDBCollection coll, List<? extends DBObject> pipeline) {
        this.fongoDB = fongoDB;
        this.fongoDBCollection = coll;
        this.pipeline = pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBObject> computeResult() {
        DBCollection coll = this.fongoDB.createCollection(UUID.randomUUID().toString(), (DBObject)new BasicDBObject());
        try {
            coll.insert(this.fongoDBCollection.find().toArray());
            for (DBObject list : this.pipeline) {
                boolean found = false;
                for (PipelineKeyword keyword : keywords) {
                    if (!keyword.canApply(list)) continue;
                    coll = keyword.apply(this.fongoDBCollection.getDB(), coll, list);
                    found = true;
                    break;
                }
                if (found) continue;
                this.fongoDB.notOkErrorResult(16436, "exception: Unrecognized pipeline stage name: '" + list.keySet() + "'").throwOnError();
            }
            List result = coll.find().toArray();
            LOG.debug("computeResult() : {}", (Object)result);
            List list = result;
            return list;
        }
        finally {
            coll.drop();
        }
    }
}

