/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.FongoException;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkUpdateRequestBuilder;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerVersion;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.operation.FongoBsonArrayWrapper;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.FieldNameValidator;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(FongoConnection.class);
    private final Fongo fongo;
    private final ConnectionDescription connectionDescription;
    private static final List<String> IGNORED_KEYS = Arrays.asList("ok", "err", "code");

    public FongoConnection(final Fongo fongo) {
        this.fongo = fongo;
        this.connectionDescription = new ConnectionDescription(new ServerId(new ClusterId(), fongo.getServerAddress())){

            public ServerVersion getServerVersion() {
                return fongo.getServerVersion();
            }
        };
    }

    public Connection retain() {
        LOG.debug("retain()");
        return this;
    }

    public ConnectionDescription getDescription() {
        return this.connectionDescription;
    }

    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        LOG.debug("insert() namespace:{} inserts:{}", (Object)namespace, inserts);
        FongoDBCollection collection = this.dbCollection(namespace);
        for (InsertRequest insert : inserts) {
            DBObject parse = FongoDBCollection.dbObject(insert.getDocument());
            collection.insert(parse, writeConcern);
            LOG.debug("insert() namespace:{} insert:{}, parse:{}", new Object[]{namespace, insert.getDocument(), parse.getClass()});
        }
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)inserts.size(), (boolean)false, null);
        }
        return WriteConcernResult.unacknowledged();
    }

    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        LOG.debug("update() namespace:{} updates:{}", (Object)namespace, updates);
        FongoDBCollection collection = this.dbCollection(namespace);
        boolean isUpdateOfExisting = false;
        BsonValue upsertedId = null;
        int count = 0;
        for (UpdateRequest update : updates) {
            Object validator = update.getType() == WriteRequest.Type.REPLACE ? new CollectibleDocumentFieldNameValidator() : new UpdateFieldNameValidator();
            for (String updateName : update.getUpdate().keySet()) {
                if (validator.validate(updateName)) continue;
                throw new IllegalArgumentException("Invalid BSON field name " + updateName);
            }
            WriteResult writeResult = collection.update(FongoDBCollection.dbObject(update.getFilter()), FongoDBCollection.dbObject(update.getUpdate()), update.isUpsert(), update.isMulti());
            if (writeResult.isUpdateOfExisting()) {
                isUpdateOfExisting = true;
                count += writeResult.getN();
                continue;
            }
            if (update.isUpsert()) {
                BsonValue updateId = update.getUpdate().get((Object)"_id", null);
                if (updateId != null) {
                    upsertedId = updateId;
                } else {
                    BsonDocument bsonDoc = FongoDBCollection.bsonDocument((DBObject)new BasicDBObject("_id", writeResult.getUpsertedId()));
                    upsertedId = bsonDoc.get((Object)"_id");
                }
                ++count;
                continue;
            }
            count += writeResult.getN();
        }
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)count, (boolean)isUpdateOfExisting, upsertedId);
        }
        return WriteConcernResult.unacknowledged();
    }

    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        LOG.debug("delete() namespace:{} deletes:{}", (Object)namespace, deletes);
        FongoDBCollection collection = this.dbCollection(namespace);
        int count = this.delete(collection, writeConcern, deletes);
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)count, (count != 0 ? 1 : 0) != 0, null);
        }
        return WriteConcernResult.unacknowledged();
    }

    public BulkWriteResult insertCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        return this.insertCommand(namespace, ordered, writeConcern, false, inserts);
    }

    public BulkWriteResult insertCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<InsertRequest> inserts) {
        LOG.debug("insertCommand() namespace:{} inserts:{}", (Object)namespace, inserts);
        FongoDBCollection collection = this.dbCollection(namespace);
        BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.fongo.getServerAddress(), ordered, writeConcern);
        IndexMap indexMap = IndexMap.create();
        BulkWriteOperation bulkWriteOperation = collection.initializeOrderedBulkOperation();
        try {
            for (InsertRequest insert : inserts) {
                if (!Boolean.TRUE.equals(bypassDocumentValidation)) {
                    CollectibleDocumentFieldNameValidator validator = new CollectibleDocumentFieldNameValidator();
                    for (String updateName : insert.getDocument().keySet()) {
                        if (validator.validate(updateName)) continue;
                        throw new IllegalArgumentException("Invalid BSON field name " + updateName);
                    }
                }
                bulkWriteOperation.insert(FongoDBCollection.dbObject(insert.getDocument()));
                indexMap = indexMap.add(1, 0);
            }
            com.mongodb.BulkWriteResult bulkWriteResult = bulkWriteOperation.execute(writeConcern);
            bulkWriteBatchCombiner.addResult(this.bulkWriteResult(bulkWriteResult), indexMap);
        }
        catch (WriteConcernException writeException) {
            if (writeException.getResponse().get((Object)"wtimeout") != null) {
                bulkWriteBatchCombiner.addWriteConcernErrorResult(this.getWriteConcernError(writeException));
            }
            bulkWriteBatchCombiner.addWriteErrorResult(this.getBulkWriteError(writeException), indexMap);
        }
        return bulkWriteBatchCombiner.getResult();
    }

    BulkWriteError getBulkWriteError(WriteConcernException writeException) {
        return new BulkWriteError(writeException.getErrorCode(), writeException.getErrorMessage(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()), 0);
    }

    WriteConcernError getWriteConcernError(WriteConcernException writeException) {
        return new WriteConcernError(writeException.getErrorCode(), ((BsonString)writeException.getResponse().get((Object)"err")).getValue(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()));
    }

    private BsonDocument translateGetLastErrorResponseToErrInfo(BsonDocument response) {
        BsonDocument errInfo = new BsonDocument();
        for (Map.Entry entry : response.entrySet()) {
            if (IGNORED_KEYS.contains(entry.getKey())) continue;
            errInfo.put((String)entry.getKey(), (BsonValue)entry.getValue());
        }
        return errInfo;
    }

    public BulkWriteResult updateCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        return this.updateCommand(namespace, ordered, writeConcern, false, updates);
    }

    public BulkWriteResult updateCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<UpdateRequest> updates) {
        LOG.debug("updateCommand() namespace:{} updates:{}", (Object)namespace, updates);
        FongoDBCollection collection = this.dbCollection(namespace);
        BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.fongo.getServerAddress(), ordered, writeConcern);
        int idx = 0;
        int offset = 0;
        for (UpdateRequest update : updates) {
            IndexMap indexMap = IndexMap.create((int)offset, (int)1);
            BulkWriteOperation bulkWriteOperation = collection.initializeOrderedBulkOperation();
            if (Boolean.TRUE.equals(bypassDocumentValidation)) {
                Object validator = update.getType() == WriteRequest.Type.REPLACE || update.getType() == WriteRequest.Type.INSERT ? new CollectibleDocumentFieldNameValidator() : new UpdateFieldNameValidator();
                for (String updateName : update.getUpdate().keySet()) {
                    if (validator.validate(updateName)) continue;
                    throw new IllegalArgumentException("Invalid BSON field name " + updateName);
                }
            }
            switch (update.getType()) {
                case REPLACE: {
                    if (update.isUpsert()) {
                        bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).upsert().replaceOne(FongoDBCollection.dbObject(update.getUpdate()));
                        break;
                    }
                    bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).replaceOne(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case INSERT: {
                    bulkWriteOperation.insert(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case UPDATE: {
                    if (update.isUpsert()) {
                        BulkUpdateRequestBuilder upsert = bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).upsert();
                        if (update.isMulti()) {
                            upsert.update(FongoDBCollection.dbObject(update.getUpdate()));
                            break;
                        }
                        upsert.updateOne(FongoDBCollection.dbObject(update.getUpdate()));
                        break;
                    }
                    BulkWriteRequestBuilder bulkWriteRequestBuilder = bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter()));
                    if (update.isMulti()) {
                        bulkWriteRequestBuilder.update(FongoDBCollection.dbObject(update.getUpdate()));
                        break;
                    }
                    bulkWriteRequestBuilder.updateOne(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case DELETE: {
                    bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).removeOne();
                }
            }
            com.mongodb.BulkWriteResult bulkWriteResult = bulkWriteOperation.execute(writeConcern);
            indexMap = indexMap.add(0, offset);
            BulkWriteResult bwr = this.bulkWriteResult(bulkWriteResult);
            int upsertCount = bwr.getUpserts().size();
            offset += upsertCount;
            bulkWriteBatchCombiner.addResult(bwr, indexMap);
            ++idx;
        }
        return bulkWriteBatchCombiner.getResult();
    }

    public BulkWriteResult deleteCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        LOG.debug("deleteCommand() namespace:{} deletes:{}", (Object)namespace, deletes);
        FongoDBCollection collection = this.dbCollection(namespace);
        int count = this.delete(collection, writeConcern, deletes);
        if (writeConcern.isAcknowledged()) {
            return BulkWriteResult.acknowledged((WriteRequest.Type)WriteRequest.Type.DELETE, (int)count, (Integer)(writeConcern.isAcknowledged() ? Integer.valueOf(deletes.size()) : null), Collections.emptyList());
        }
        return BulkWriteResult.unacknowledged();
    }

    private int delete(DBCollection collection, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        int count = 0;
        for (DeleteRequest delete : deletes) {
            DBObject parse = FongoDBCollection.dbObject(delete.getFilter());
            if (delete.isMulti()) {
                WriteResult writeResult = collection.remove(parse, writeConcern);
                count += writeResult.getN();
                continue;
            }
            DBObject dbObject = collection.findAndRemove(parse);
            if (dbObject == null) continue;
            ++count;
        }
        return count;
    }

    public <T> T command(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        FongoDB db = this.fongo.getDB(database);
        LOG.debug("command() database:{}, command:{}", (Object)database, (Object)command);
        if (command.containsKey((Object)"count")) {
            FongoDBCollection dbCollection = (FongoDBCollection)db.getCollection(command.get((Object)"count").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            long limit = command.containsKey((Object)"limit") ? command.getInt64((Object)"limit").longValue() : -1L;
            long skip = command.containsKey((Object)"skip") ? command.getInt64((Object)"skip").longValue() : 0L;
            return (T)new BsonDocument("n", (BsonValue)new BsonInt64(dbCollection.getCount(query, null, limit, skip, dbCollection.getReadPreference(), 0L, TimeUnit.MICROSECONDS, null)));
        }
        if (command.containsKey((Object)"findandmodify")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"findandmodify").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            DBObject update = FongoDBCollection.dbObject(command, "update");
            DBObject fields = FongoDBCollection.dbObject(command, "fields");
            DBObject sort = FongoDBCollection.dbObject(command, "sort");
            boolean returnNew = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"new", BsonBoolean.FALSE));
            boolean upsert = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"upsert", BsonBoolean.FALSE));
            boolean remove = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"remove", BsonBoolean.FALSE));
            if (update != null) {
                FieldNameValidator validatorUpdate = fieldNameValidator.getValidatorForField("update");
                for (String updateName : update.keySet()) {
                    if (validatorUpdate.validate(updateName)) continue;
                    throw new IllegalArgumentException("Invalid BSON field name " + updateName);
                }
            }
            DBObject andModify = dbCollection.findAndModify(query, fields, sort, remove, update, returnNew, upsert);
            return this.reencode(commandResultDecoder, "value", andModify);
        }
        if (command.containsKey((Object)"distinct")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"distinct").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            List distincts = dbCollection.distinct(command.getString((Object)"key").getValue(), query);
            return (T)new BsonDocument("values", FongoBsonArrayWrapper.bsonArrayWrapper(distincts));
        }
        if (command.containsKey((Object)"aggregate")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"aggregate").asString().getValue());
            AggregationOutput aggregate = dbCollection.aggregate(FongoDBCollection.dbObjects(command, "pipeline"));
            boolean v3 = command.containsKey((Object)"cursor");
            String resultField = v3 ? "cursor" : "result";
            Iterable results = aggregate.results();
            if (!v3) {
                return this.reencode(commandResultDecoder, resultField, results);
            }
            List<Document> each = this.documents(results);
            return (T)new BsonDocument("cursor", (BsonValue)new BsonDocument("id", (BsonValue)new BsonInt64(0L)).append("ns", (BsonValue)new BsonString(dbCollection.getFullName())).append("firstBatch", FongoBsonArrayWrapper.bsonArrayWrapper(each)));
        }
        if (command.containsKey((Object)"renameCollection")) {
            db.renameCollection(command.getString((Object)"renameCollection").getValue(), command.getString((Object)"to").getValue(), command.getBoolean((Object)"dropTarget", BsonBoolean.FALSE).getValue());
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"createIndexes")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"createIndexes").asString().getValue());
            List indexes = command.getArray((Object)"indexes").getValues();
            for (BsonValue indexBson : indexes) {
                BsonDocument bsonDocument = indexBson.asDocument();
                DBObject keys = FongoDBCollection.dbObject(bsonDocument.getDocument((Object)"key"));
                String name = bsonDocument.getString((Object)"name").getValue();
                boolean unique = bsonDocument.getBoolean((Object)"unique", BsonBoolean.FALSE).getValue();
                dbCollection.createIndex(keys, name, unique);
            }
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"drop")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"drop").asString().getValue());
            dbCollection.drop();
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"listIndexes")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"listIndexes").asString().getValue());
            BasicDBObject cmd = new BasicDBObject();
            cmd.put((Object)"ns", (Object)dbCollection.getFullName());
            DBCursor cur = dbCollection.getDB().getCollection("system.indexes").find((DBObject)cmd);
            List<Document> each = this.documents(cur.toArray());
            return (T)new BsonDocument("cursor", (BsonValue)new BsonDocument("id", (BsonValue)new BsonInt64(0L)).append("ns", (BsonValue)new BsonString(dbCollection.getFullName())).append("firstBatch", FongoBsonArrayWrapper.bsonArrayWrapper(each)));
        }
        if (command.containsKey((Object)"listCollections")) {
            ArrayList<BasicDBObject> result = new ArrayList<BasicDBObject>();
            for (String name : db.getCollectionNames()) {
                result.add(new BasicDBObject("name", (Object)name).append("options", (Object)new BasicDBObject()));
            }
            return this.reencode(commandResultDecoder, "cursor", (DBObject)new BasicDBObject("id", (Object)0L).append("ns", (Object)(db.getName() + ".dontkown")).append("firstBatch", result));
        }
        if (command.containsKey((Object)"dropDatabase")) {
            db.dropDatabase();
            return null;
        }
        LOG.warn("Command not implemented: {}", (Object)command);
        throw new FongoException("Not implemented for command : " + JSON.serialize((Object)FongoDBCollection.dbObject(command)));
    }

    private List<Document> documents(Iterable<DBObject> list) {
        Codec documentCodec = MongoClient.getDefaultCodecRegistry().get(Document.class);
        ArrayList<Document> each = new ArrayList<Document>();
        for (DBObject result : list) {
            Document decode = (Document)documentCodec.decode((BsonReader)new BsonDocumentReader(FongoDBCollection.bsonDocument(result)), FongoDBCollection.decoderContext());
            each.add(decode);
        }
        return each;
    }

    private <T> T reencode(Decoder<T> commandResultDecoder, String resultField, Iterable<DBObject> results) {
        return (T)commandResultDecoder.decode((BsonReader)new BsonDocumentReader(new BsonDocument(resultField, (BsonValue)new BsonArray(FongoDBCollection.bsonDocuments(results)))), FongoDBCollection.decoderContext());
    }

    private <T> T reencode(Decoder<T> commandResultDecoder, String resultField, DBObject result) {
        Object value = result == null ? new BsonNull() : FongoDBCollection.bsonDocument(result);
        return (T)commandResultDecoder.decode((BsonReader)new BsonDocumentReader(new BsonDocument(resultField, (BsonValue)value)), FongoDBCollection.decoderContext());
    }

    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        LOG.debug("query() namespace:{} queryDocument:{}, fields:{}", new Object[]{namespace, queryDocument, fields});
        FongoDBCollection collection = this.dbCollection(namespace);
        List objects = collection.find(FongoDBCollection.dbObject(queryDocument), FongoDBCollection.dbObject(fields)).limit(numberToReturn).skip(skip).toArray();
        return new QueryResult(namespace, FongoDBCollection.decode(objects, resultDecoder), 1L, this.fongo.getServerAddress());
    }

    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        return this.query(namespace, queryDocument, fields, limit, skip, slaveOk, tailableCursor, awaitData, noCursorTimeout, partial, oplogReplay, resultDecoder);
    }

    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder) {
        LOG.debug("getMore() namespace:{} cursorId:{}", (Object)namespace, (Object)cursorId);
        return new QueryResult(namespace, Collections.emptyList(), 0L, this.fongo.getServerAddress());
    }

    public void killCursor(List<Long> cursors) {
        LOG.info("killCursor() cursors:{}", cursors);
    }

    public void killCursor(MongoNamespace namespace, List<Long> cursors) {
        LOG.debug("killCursor() namespace:{}, cursors:{}", (Object)namespace.getFullName(), cursors);
    }

    public int getCount() {
        LOG.info("getCount()");
        return 0;
    }

    public void release() {
        LOG.debug("release()");
    }

    private FongoDBCollection dbCollection(MongoNamespace namespace) {
        return this.fongo.getDB(namespace.getDatabaseName()).getCollection(namespace.getCollectionName());
    }

    private BulkWriteResult bulkWriteResult(com.mongodb.BulkWriteResult bulkWriteResult) {
        if (!bulkWriteResult.isAcknowledged()) {
            return BulkWriteResult.unacknowledged();
        }
        return BulkWriteResult.acknowledged((int)bulkWriteResult.getInsertedCount(), (int)bulkWriteResult.getMatchedCount(), (int)bulkWriteResult.getRemovedCount(), (Integer)bulkWriteResult.getModifiedCount(), FongoDBCollection.translateBulkWriteUpsertsToNew(bulkWriteResult.getUpserts(), null));
    }
}

