/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.Visitor;

public class ArraySchema
extends Schema {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;
    private final Schema allItemSchema;
    private final boolean additionalItems;
    private final List<Schema> itemSchemas;
    private final boolean requiresArray;
    private final Schema schemaOfAdditionalItems;
    private final Schema containedItemSchema;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(Builder builder) {
        super(builder);
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
        this.uniqueItems = builder.uniqueItems;
        this.allItemSchema = builder.allItemSchema;
        this.itemSchemas = builder.itemSchemas;
        this.additionalItems = !builder.additionalItems && this.allItemSchema != null ? true : builder.schemaOfAdditionalItems != null || builder.additionalItems;
        this.schemaOfAdditionalItems = builder.schemaOfAdditionalItems;
        if (this.allItemSchema != null && this.itemSchemas != null) {
            throw new SchemaException("cannot perform both tuple and list validation");
        }
        this.requiresArray = builder.requiresArray;
        this.containedItemSchema = builder.containedItemSchema;
    }

    public Schema getAllItemSchema() {
        return this.allItemSchema;
    }

    public List<Schema> getItemSchemas() {
        return this.itemSchemas;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema getSchemaOfAdditionalItems() {
        return this.schemaOfAdditionalItems;
    }

    public Schema getContainedItemSchema() {
        return this.containedItemSchema;
    }

    public boolean needsUniqueItems() {
        return this.uniqueItems;
    }

    public boolean permitsAdditionalItems() {
        return this.additionalItems;
    }

    public boolean requiresArray() {
        return this.requiresArray;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)o;
            return that.canEqual(this) && this.uniqueItems == that.uniqueItems && this.additionalItems == that.additionalItems && this.requiresArray == that.requiresArray && Objects.equals(this.minItems, that.minItems) && Objects.equals(this.maxItems, that.maxItems) && Objects.equals(this.allItemSchema, that.allItemSchema) && Objects.equals(this.itemSchemas, that.itemSchemas) && Objects.equals(this.schemaOfAdditionalItems, that.schemaOfAdditionalItems) && Objects.equals(this.containedItemSchema, that.containedItemSchema) && super.equals(o);
        }
        return false;
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitArraySchema(this);
    }

    @Override
    public boolean definesProperty(String field) {
        String[] headAndTail = this.headAndTailOfJsonPointerFragment(field);
        String nextToken = headAndTail[0];
        String remaining = headAndTail[1];
        boolean hasRemaining = remaining != null;
        try {
            return this.tryPropertyDefinitionByNumericIndex(nextToken, remaining, hasRemaining);
        }
        catch (NumberFormatException e) {
            return this.tryPropertyDefinitionByMetaIndex(nextToken, remaining, hasRemaining);
        }
    }

    private boolean tryPropertyDefinitionByMetaIndex(String nextToken, String remaining, boolean hasRemaining) {
        boolean isAll = "all".equals(nextToken);
        boolean isAny = "any".equals(nextToken);
        if (!hasRemaining && (isAll || isAny)) {
            return true;
        }
        if (isAll) {
            if (this.allItemSchema != null) {
                return this.allItemSchema.definesProperty(remaining);
            }
            boolean allItemSchemasDefine = this.itemSchemas.stream().map(schema -> schema.definesProperty(remaining)).reduce(true, Boolean::logicalAnd);
            if (allItemSchemasDefine) {
                if (this.schemaOfAdditionalItems != null) {
                    return this.schemaOfAdditionalItems.definesProperty(remaining);
                }
                return true;
            }
            return false;
        }
        if (isAny) {
            if (this.allItemSchema != null) {
                return this.allItemSchema.definesProperty(remaining);
            }
            boolean anyItemSchemasDefine = this.itemSchemas.stream().map(schema -> schema.definesProperty(remaining)).reduce(false, Boolean::logicalOr);
            return anyItemSchemasDefine || this.schemaOfAdditionalItems == null || this.schemaOfAdditionalItems.definesProperty(remaining);
        }
        return false;
    }

    private boolean tryPropertyDefinitionByNumericIndex(String nextToken, String remaining, boolean hasRemaining) {
        int index = Integer.parseInt(nextToken);
        if (index < 0) {
            return false;
        }
        if (this.maxItems != null && this.maxItems <= index) {
            return false;
        }
        if (this.allItemSchema != null && hasRemaining) {
            return this.allItemSchema.definesProperty(remaining);
        }
        if (hasRemaining) {
            if (index < this.itemSchemas.size()) {
                return this.itemSchemas.get(index).definesProperty(remaining);
            }
            if (this.schemaOfAdditionalItems != null) {
                return this.schemaOfAdditionalItems.definesProperty(remaining);
            }
        }
        return this.additionalItems;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArraySchema;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minItems, this.maxItems, this.uniqueItems, this.allItemSchema, this.additionalItems, this.itemSchemas, this.requiresArray, this.schemaOfAdditionalItems, this.containedItemSchema);
    }

    public static class Builder
    extends Schema.Builder<ArraySchema> {
        private boolean requiresArray = true;
        private Integer minItems;
        private Integer maxItems;
        private boolean uniqueItems = false;
        private Schema allItemSchema;
        private List<Schema> itemSchemas = null;
        private boolean additionalItems = true;
        private Schema schemaOfAdditionalItems;
        private Schema containedItemSchema;

        public Builder addItemSchema(Schema itemSchema) {
            if (this.itemSchemas == null) {
                this.itemSchemas = new ArrayList<Schema>();
            }
            this.itemSchemas.add(Objects.requireNonNull(itemSchema, "itemSchema cannot be null"));
            return this;
        }

        public Builder additionalItems(boolean additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        public Builder allItemSchema(Schema allItemSchema) {
            this.allItemSchema = allItemSchema;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder requiresArray(boolean requiresArray) {
            this.requiresArray = requiresArray;
            return this;
        }

        public Builder schemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
            this.schemaOfAdditionalItems = schemaOfAdditionalItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        public Builder containsItemSchema(Schema contained) {
            this.containedItemSchema = contained;
            return this;
        }
    }
}

