/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.phoenixframework.channels.Binding;
import org.phoenixframework.channels.ChannelEvent;
import org.phoenixframework.channels.ChannelState;
import org.phoenixframework.channels.Envelope;
import org.phoenixframework.channels.IErrorCallback;
import org.phoenixframework.channels.IMessageCallback;
import org.phoenixframework.channels.ITimeoutCallback;
import org.phoenixframework.channels.Push;
import org.phoenixframework.channels.Socket;

public class Channel {
    private static final Logger LOG = Logger.getLogger(Channel.class.getName());
    private static final long DEFAULT_TIMEOUT = 5000L;
    private final List<Binding> bindings = new ArrayList<Binding>();
    private Timer channelTimer = null;
    private final Push joinPush;
    private boolean joinedOnce = false;
    private final JsonNode payload;
    private final LinkedBlockingDeque<Push> pushBuffer = new LinkedBlockingDeque();
    private final Socket socket;
    private ChannelState state = ChannelState.CLOSED;
    private final String topic;

    public Channel(String topic, JsonNode payload, Socket socket) {
        this.topic = topic;
        this.payload = payload;
        this.socket = socket;
        this.joinPush = new Push(this, ChannelEvent.JOIN.getPhxEvent(), payload, 5000L);
        this.channelTimer = new Timer("Phx Rejoin timer for " + topic);
        this.joinPush.receive("ok", new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                Channel.this.state = ChannelState.JOINED;
            }
        });
        this.joinPush.timeout(new ITimeoutCallback(){

            @Override
            public void onTimeout() {
                Channel.this.state = ChannelState.ERRORED;
            }
        });
        this.onClose(new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                Channel.this.state = ChannelState.CLOSED;
                Channel.this.socket.remove(Channel.this);
            }
        });
        this.onError(new IErrorCallback(){

            @Override
            public void onError(String reason) {
                Channel.this.state = ChannelState.ERRORED;
                Channel.this.scheduleRejoinTimer();
            }
        });
        this.on(ChannelEvent.REPLY.getPhxEvent(), new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                Channel.this.trigger(Socket.replyEventName(envelope.getRef()), envelope);
            }
        });
    }

    private boolean canPush() {
        return this.socket.isConnected() && this.state == ChannelState.JOINED;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isMember(String topic) {
        return this.topic.equals(topic);
    }

    public Push join() throws IllegalStateException, IOException {
        if (this.joinedOnce) {
            throw new IllegalStateException("Tried to join multiple times. 'join' can only be invoked once per channel");
        }
        this.joinedOnce = true;
        this.sendJoin();
        return this.joinPush;
    }

    public Push leave() throws IOException {
        return this.push(ChannelEvent.LEAVE.getPhxEvent()).receive("ok", new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                Channel.this.trigger(ChannelEvent.CLOSE.getPhxEvent(), null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel off(String event) {
        List<Binding> list = this.bindings;
        synchronized (list) {
            Iterator<Binding> bindingIter = this.bindings.iterator();
            while (bindingIter.hasNext()) {
                if (!bindingIter.next().getEvent().equals(event)) continue;
                bindingIter.remove();
                break;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel on(String event, IMessageCallback callback) {
        List<Binding> list = this.bindings;
        synchronized (list) {
            this.bindings.add(new Binding(event, callback));
        }
        return this;
    }

    private void onClose(IMessageCallback callback) {
        this.on(ChannelEvent.CLOSE.getPhxEvent(), callback);
    }

    private void onError(final IErrorCallback callback) {
        this.on(ChannelEvent.ERROR.getPhxEvent(), new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                String reason = null;
                if (envelope != null) {
                    reason = envelope.getReason();
                }
                callback.onError(reason);
            }
        });
    }

    private Push push(String event, JsonNode payload, long timeout) throws IOException, IllegalStateException {
        if (!this.joinedOnce) {
            throw new IllegalStateException("Unable to push event before channel has been joined");
        }
        Push pushEvent = new Push(this, event, payload, timeout);
        if (this.canPush()) {
            pushEvent.send();
        } else {
            this.pushBuffer.add(pushEvent);
        }
        return pushEvent;
    }

    public Push push(String event, JsonNode payload) throws IOException {
        return this.push(event, payload, 5000L);
    }

    public Push push(String event) throws IOException {
        return this.push(event, null);
    }

    private void rejoin() throws IOException {
        this.sendJoin();
        while (!this.pushBuffer.isEmpty()) {
            this.pushBuffer.removeFirst().send();
        }
    }

    private void rejoinUntilConnected() throws IOException {
        if (this.state == ChannelState.ERRORED) {
            if (this.socket.isConnected()) {
                this.rejoin();
            } else {
                this.scheduleRejoinTimer();
            }
        }
    }

    public void scheduleRepeatingTask(TimerTask timerTask, long ms) {
        this.channelTimer.schedule(timerTask, ms, ms);
    }

    public void scheduleTask(TimerTask timerTask, long ms) {
        this.channelTimer.schedule(timerTask, ms);
    }

    public String toString() {
        return "Channel{topic='" + this.topic + '\'' + ", message=" + this.payload + ", bindings=" + this.bindings + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trigger(String triggerEvent, Envelope envelope) {
        List<Binding> list = this.bindings;
        synchronized (list) {
            for (Binding binding : this.bindings) {
                if (!binding.getEvent().equals(triggerEvent)) continue;
                binding.getCallback().onMessage(envelope);
                break;
            }
        }
    }

    private void scheduleRejoinTimer() {
        TimerTask rejoinTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    Channel.this.rejoinUntilConnected();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to rejoin", e);
                }
            }
        };
        this.scheduleTask(rejoinTimerTask, 5000L);
    }

    private void sendJoin() throws IOException {
        this.state = ChannelState.JOINING;
        this.joinPush.send();
    }
}

