/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.widget.SectionIndexer;
import androidx.annotation.Nullable;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import java.util.ArrayList;

public abstract class AdvancedSectionAdapter<T>
extends AdvancedAdapter<T>
implements SectionIndexer {
    private ArrayList<Section> mSections = new ArrayList();

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateAlphaIndexer();
    }

    public int getPositionForSection(int section) {
        section = section < 0 ? 0 : section;
        section = section >= this.mSections.size() ? this.mSections.size() - 1 : section;
        return this.mSections.get((int)section).startingPosition;
    }

    public int getSectionForPosition(int position) {
        for (int i = this.mSections.size() - 1; i >= 0; --i) {
            if (position < this.mSections.get((int)i).startingPosition) continue;
            return i;
        }
        return 0;
    }

    public Object[] getSections() {
        return this.mSections.toArray();
    }

    @Nullable
    public abstract String getSectionTitle(T var1);

    private void updateAlphaIndexer() {
        this.mSections.clear();
        String currentSection = null;
        for (int i = 0; i < this.getCount(); ++i) {
            String title = this.getSectionTitle(this.getItem(i));
            if (title == null || title.equals(currentSection)) continue;
            this.mSections.add(new Section(title, i));
            currentSection = title;
        }
        if (this.mSections.size() == 0) {
            this.mSections.add(new Section(null, 0));
        }
    }

    class Section {
        String title;
        int startingPosition;

        Section(String text, int pos) {
            this.title = text;
            this.startingPosition = pos;
        }

        public String toString() {
            return this.title;
        }
    }
}

