/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import eltos.simpledialogfragment.form.FormElementViewHolder;

public abstract class FormElement<T extends FormElement, V extends FormElementViewHolder>
implements Parcelable {
    protected static final int NO_ID = -1;
    protected String resultKey;
    protected boolean required = false;
    private String text = null;
    private int textResourceId = -1;

    protected FormElement(String resultKey) {
        this.resultKey = resultKey;
    }

    public abstract V buildViewHolder();

    public T required() {
        return this.required(true);
    }

    public T required(boolean required) {
        this.required = required;
        return (T)this;
    }

    public T label(String text) {
        this.text = text;
        return (T)this;
    }

    public T label(@StringRes int textResourceId) {
        this.textResourceId = textResourceId;
        return (T)this;
    }

    @Nullable
    protected String getText(Context context) {
        if (this.text != null) {
            return this.text;
        }
        if (this.textResourceId != -1) {
            return context.getString(this.textResourceId);
        }
        return null;
    }

    protected FormElement(Parcel in) {
        this.resultKey = in.readString();
        this.required = in.readByte() != 0;
        this.text = in.readString();
        this.textResourceId = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.resultKey);
        dest.writeByte((byte)(this.required ? 1 : 0));
        dest.writeString(this.text);
        dest.writeInt(this.textResourceId);
    }
}

