/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.color.ColorWheelView;

public class SimpleColorWheelDialog
extends CustomViewDialog<SimpleColorWheelDialog> {
    public static final String TAG = "SimpleColorWheelDialog.";
    public static final String COLOR = "SimpleColorWheelDialog.color";
    protected static final String ALPHA = "SimpleColorWheelDialog.alpha";
    private static final String HIDE_HEX = "SimpleColorWheelDialog.noHex";
    private ColorWheelView mColorWheelView;
    private EditText mHexInput;
    private ImageView mNew;
    private ImageView mOld;
    private SeekBar mAlphaSlider;
    private View mTransparency;
    private final TextWatcher hexEditWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            try {
                int color = (255 - SimpleColorWheelDialog.this.mAlphaSlider.getProgress() << 24) + (int)Long.parseLong(s.toString(), 16);
                SimpleColorWheelDialog.this.mColorWheelView.setColor(color, false);
                SimpleColorWheelDialog.this.mNew.setImageDrawable((Drawable)new ColorDrawable(color));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    };

    public static SimpleColorWheelDialog build() {
        return new SimpleColorWheelDialog();
    }

    public SimpleColorWheelDialog color(int color) {
        return (SimpleColorWheelDialog)((Object)this.setArg(COLOR, color));
    }

    public SimpleColorWheelDialog alpha(boolean enabled) {
        return (SimpleColorWheelDialog)((Object)this.setArg(ALPHA, enabled));
    }

    public SimpleColorWheelDialog hideHexInput(boolean enabled) {
        return (SimpleColorWheelDialog)((Object)this.setArg(HIDE_HEX, enabled));
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        View view = this.inflate(R.layout.simpledialogfragment_color_wheel);
        this.mColorWheelView = (ColorWheelView)view.findViewById(R.id.colorWheel);
        this.mTransparency = view.findViewById(R.id.transparencyBox);
        this.mAlphaSlider = (SeekBar)view.findViewById(R.id.alpha);
        this.mHexInput = (EditText)view.findViewById(R.id.hexEditText);
        this.mNew = (ImageView)view.findViewById(R.id.colorNew);
        this.mOld = (ImageView)view.findViewById(R.id.colorOld);
        View hexLayout = view.findViewById(R.id.hexLayout);
        int color = this.getArguments().getInt(COLOR, ColorWheelView.DEFAULT_COLOR);
        int oldColor = this.getArguments().getInt(COLOR);
        if (!this.getArguments().getBoolean(ALPHA)) {
            color |= 0xFF000000;
            oldColor |= 0xFF000000;
        }
        this.mColorWheelView.setColor(color);
        this.mNew.setImageDrawable((Drawable)new ColorDrawable(color));
        this.mAlphaSlider.setMax(255);
        this.mAlphaSlider.setProgress(255 - Color.alpha((int)color));
        this.mHexInput.setText((CharSequence)String.format("%06X", color & 0xFFFFFF));
        hexLayout.setVisibility(this.getArguments().getBoolean(HIDE_HEX) ? 8 : 0);
        this.mOld.setVisibility(this.getArguments().containsKey(COLOR) ? 0 : 8);
        this.mOld.setImageDrawable((Drawable)new ColorDrawable(oldColor));
        final int finalOldColor = oldColor;
        this.mOld.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleColorWheelDialog.this.mColorWheelView.setColor(finalOldColor);
                SimpleColorWheelDialog.this.mAlphaSlider.setProgress(255 - Color.alpha((int)finalOldColor));
            }
        });
        this.mHexInput.addTextChangedListener(this.hexEditWatcher);
        this.mColorWheelView.setOnColorChangeListener(new ColorWheelView.OnColorChangeListener(){

            @Override
            public void onColorChange(int color) {
                SimpleColorWheelDialog.this.mHexInput.removeTextChangedListener(SimpleColorWheelDialog.this.hexEditWatcher);
                SimpleColorWheelDialog.this.mHexInput.setText((CharSequence)String.format("%06X", color & 0xFFFFFF));
                SimpleColorWheelDialog.this.mHexInput.addTextChangedListener(SimpleColorWheelDialog.this.hexEditWatcher);
                SimpleColorWheelDialog.this.mNew.setImageDrawable((Drawable)new ColorDrawable(color));
            }
        });
        this.mTransparency.setVisibility(this.getArguments().getBoolean(ALPHA) ? 0 : 8);
        this.mAlphaSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    SimpleColorWheelDialog.this.mColorWheelView.updateAlpha(255 - progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        return view;
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle results = new Bundle();
        results.putInt(COLOR, this.mColorWheelView.getColor());
        return results;
    }
}

