/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import com.google.android.material.textfield.TextInputLayout;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDateDialog;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.SimpleTimeDialog;
import eltos.simpledialogfragment.form.DateTime;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.SimpleFormDialog;
import java.text.SimpleDateFormat;
import java.util.Date;

class DateTimeViewHolder
extends FormElementViewHolder<DateTime>
implements SimpleDialog.OnDialogResultListener {
    protected static final String SAVED_DATE = "date";
    protected static final String SAVED_HOUR = "hour";
    protected static final String SAVED_MINUTE = "minute";
    private static final String DATE_DIALOG_TAG = "datePickerDialogTag";
    private static final String TIME_DIALOG_TAG = "timePickerDialogTag";
    private EditText date;
    private EditText time;
    private TextInputLayout dateLayout;
    private TextInputLayout timeLayout;
    private Long day;
    private Integer hour;
    private Integer minute;

    public DateTimeViewHolder(DateTime field) {
        super(field);
    }

    @Override
    protected int getContentViewLayout() {
        return R.layout.simpledialogfragment_form_item_datetime;
    }

    @Override
    protected void setUpView(View view, final Context context, Bundle savedInstanceState, final SimpleFormDialog.DialogActions actions) {
        this.date = (EditText)view.findViewById(R.id.date);
        this.time = (EditText)view.findViewById(R.id.time);
        this.dateLayout = (TextInputLayout)view.findViewById(R.id.dateLayout);
        this.timeLayout = (TextInputLayout)view.findViewById(R.id.timeLayout);
        String text = ((DateTime)this.field).getText(context);
        if (text != null) {
            this.dateLayout.setHint((CharSequence)text);
            if (((DateTime)this.field).type == DateTime.Type.TIME) {
                this.timeLayout.setHint((CharSequence)text);
            }
        }
        this.dateLayout.setVisibility(((DateTime)this.field).type == DateTime.Type.DATETIME || ((DateTime)this.field).type == DateTime.Type.DATE ? 0 : 8);
        this.date.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleDateDialog dialog = (SimpleDateDialog)((Object)((SimpleDateDialog)((Object)SimpleDateDialog.build().title(((DateTime)DateTimeViewHolder.this.field).getText(context)))).neut());
                if (((DateTime)DateTimeViewHolder.this.field).min != null) {
                    dialog.minDate(((DateTime)DateTimeViewHolder.this.field).min);
                }
                if (((DateTime)DateTimeViewHolder.this.field).max != null) {
                    dialog.maxDate(((DateTime)DateTimeViewHolder.this.field).max);
                }
                if (!((DateTime)DateTimeViewHolder.this.field).required) {
                    dialog.neg(R.string.clear);
                }
                if (DateTimeViewHolder.this.day != null) {
                    dialog.date(DateTimeViewHolder.this.day);
                }
                actions.showDialog(dialog, DateTimeViewHolder.DATE_DIALOG_TAG + ((DateTime)DateTimeViewHolder.this.field).resultKey);
            }
        });
        this.timeLayout.setVisibility(((DateTime)this.field).type == DateTime.Type.DATETIME || ((DateTime)this.field).type == DateTime.Type.TIME ? 0 : 8);
        this.time.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleTimeDialog dialog = (SimpleTimeDialog)((Object)((SimpleTimeDialog)((Object)SimpleTimeDialog.build().title(((DateTime)DateTimeViewHolder.this.field).getText(context)))).neut());
                if (DateTimeViewHolder.this.hour != null) {
                    dialog.hour(DateTimeViewHolder.this.hour);
                }
                if (DateTimeViewHolder.this.minute != null) {
                    dialog.minute(DateTimeViewHolder.this.minute);
                }
                if (!((DateTime)DateTimeViewHolder.this.field).required) {
                    dialog.neg(R.string.clear);
                }
                actions.showDialog(dialog, DateTimeViewHolder.TIME_DIALOG_TAG + ((DateTime)DateTimeViewHolder.this.field).resultKey);
            }
        });
        if (savedInstanceState != null) {
            this.day = savedInstanceState.getLong(SAVED_DATE);
            this.hour = savedInstanceState.getInt(SAVED_HOUR);
            this.minute = savedInstanceState.getInt(SAVED_MINUTE);
        } else {
            this.day = ((DateTime)this.field).date;
            this.hour = ((DateTime)this.field).hour;
            this.minute = ((DateTime)this.field).minute;
        }
        this.updateText();
    }

    private void updateText() {
        this.date.setText(this.day == null ? null : SimpleDateFormat.getDateInstance().format(new Date(this.day)));
        this.time.setText(this.hour == null || this.minute == null ? null : SimpleDateFormat.getTimeInstance(3).format(new Date(0, 0, 0, this.hour, this.minute)));
    }

    @Override
    protected void saveState(Bundle outState) {
        if (this.day != null) {
            outState.putLong(SAVED_DATE, this.day.longValue());
        }
        if (this.hour != null) {
            outState.putInt(SAVED_HOUR, this.hour.intValue());
        }
        if (this.minute != null) {
            outState.putInt(SAVED_MINUTE, this.minute.intValue());
        }
    }

    @Override
    protected void putResults(Bundle results, String key) {
        Date res = new Date(this.day == null ? 0L : this.day);
        res.setHours(this.hour == null ? 0 : this.hour);
        res.setMinutes(this.minute == null ? 0 : this.minute);
        results.putLong(key, res.getTime());
    }

    @Override
    protected boolean focus(SimpleFormDialog.FocusActions actions) {
        actions.hideKeyboard();
        if (((DateTime)this.field).type == DateTime.Type.TIME) {
            this.time.performClick();
        } else {
            this.date.performClick();
        }
        return true;
    }

    @Override
    protected boolean posButtonEnabled(Context context) {
        return !((DateTime)this.field).required || ((DateTime)this.field).type == DateTime.Type.DATE && this.day != null || ((DateTime)this.field).type == DateTime.Type.TIME && this.hour != null && this.minute != null || ((DateTime)this.field).type == DateTime.Type.DATETIME && this.day != null && this.hour != null && this.minute != null;
    }

    @Override
    protected boolean validate(Context context) {
        boolean valid = this.posButtonEnabled(context);
        this.dateLayout.setErrorEnabled(false);
        this.timeLayout.setErrorEnabled(false);
        if (!valid) {
            if (this.day == null) {
                this.dateLayout.setError((CharSequence)context.getString(R.string.required));
            }
            if (this.hour == null || this.minute == null) {
                this.timeLayout.setError((CharSequence)context.getString(R.string.required));
            }
        }
        return valid;
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        if ((DATE_DIALOG_TAG + ((DateTime)this.field).resultKey).equals(dialogTag)) {
            if (which == -1) {
                this.day = extras.getLong("SimpleDateDialog.DATE");
                this.dateLayout.setErrorEnabled(false);
                if (((DateTime)this.field).type == DateTime.Type.DATETIME) {
                    this.time.performClick();
                }
            } else if (which == -2) {
                this.day = null;
            }
            this.updateText();
            return true;
        }
        if ((TIME_DIALOG_TAG + ((DateTime)this.field).resultKey).equals(dialogTag)) {
            if (which == -1) {
                this.hour = extras.getInt("SimpleTimeDialog.HOUR");
                this.minute = extras.getInt("SimpleTimeDialog.MINUTE");
                this.timeLayout.setErrorEnabled(false);
            } else if (which == -2) {
                this.hour = null;
                this.minute = null;
            }
            this.updateText();
            return true;
        }
        return false;
    }
}

