/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import eltos.simpledialogfragment.color.SimpleColorDialog;
import eltos.simpledialogfragment.form.ColorViewHolder;
import eltos.simpledialogfragment.form.FormElement;

public class ColorField
extends FormElement<ColorField, ColorViewHolder> {
    @ColorInt
    public static final int NONE = 0;
    @ColorInt
    public static final int AUTO = 0xFFFFFF;
    @ColorInt
    private int preset = 0;
    private int presetId = -1;
    protected int[] colors = SimpleColorDialog.DEFAULT_COLORS;
    protected boolean allowCustom = true;
    protected int outline = 0;
    public static final Parcelable.Creator<ColorField> CREATOR = new Parcelable.Creator<ColorField>(){

        public ColorField createFromParcel(Parcel in) {
            return new ColorField(in);
        }

        public ColorField[] newArray(int size) {
            return new ColorField[size];
        }
    };

    private ColorField(String resultKey) {
        super(resultKey);
    }

    public static ColorField picker(String key) {
        return new ColorField(key);
    }

    public ColorField color(@ColorInt int preset) {
        this.preset = preset;
        return this;
    }

    public ColorField colorRes(@ColorRes int presetResourceId) {
        this.presetId = presetResourceId;
        return this;
    }

    public ColorField colors(@ColorInt int[] colors) {
        this.colors = colors;
        return this;
    }

    public ColorField colors(Context context, @ArrayRes int colorArrayRes) {
        return this.colors(context.getResources().getIntArray(colorArrayRes));
    }

    public ColorField allowCustom(boolean allow) {
        this.allowCustom = allow;
        return this;
    }

    public ColorField showOutline(@ColorInt int color2) {
        this.outline = color2;
        return this;
    }

    @Override
    public ColorViewHolder buildViewHolder() {
        return new ColorViewHolder(this);
    }

    @ColorInt
    protected int getInitialColor(Context context) {
        if (this.presetId != -1) {
            return context.getResources().getColor(this.presetId);
        }
        return this.preset;
    }

    protected ColorField(Parcel in) {
        super(in);
        this.preset = in.readInt();
        this.presetId = in.readInt();
        this.colors = in.createIntArray();
        this.allowCustom = in.readByte() != 0;
        this.outline = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.preset);
        dest.writeInt(this.presetId);
        dest.writeIntArray(this.colors);
        dest.writeByte((byte)(this.allowCustom ? 1 : 0));
        dest.writeInt(this.outline);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

