/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import eltos.simpledialogfragment.form.FormElement;
import eltos.simpledialogfragment.form.SpinnerViewHolder;

public class Spinner
extends FormElement<Spinner, SpinnerViewHolder> {
    private int itemArrayRes = -1;
    private int[] itemStringResArray = null;
    private String[] items = null;
    private String placeholder = null;
    private int placeholderResourceId = -1;
    int position = -1;
    public static final Parcelable.Creator<Spinner> CREATOR = new Parcelable.Creator<Spinner>(){

        public Spinner createFromParcel(Parcel in) {
            return new Spinner(in);
        }

        public Spinner[] newArray(int size) {
            return new Spinner[size];
        }
    };

    private Spinner(String resultKey) {
        super(resultKey);
    }

    public static Spinner plain(String key) {
        return new Spinner(key);
    }

    public Spinner placeholder(String text) {
        this.placeholder = text;
        return this;
    }

    public Spinner placeholder(@StringRes int textResourceId) {
        this.placeholderResourceId = textResourceId;
        return this;
    }

    public Spinner items(@ArrayRes int itemArrayRes) {
        this.itemArrayRes = itemArrayRes;
        return this;
    }

    public Spinner items(int ... itemsStringResArray) {
        if (itemsStringResArray != null && itemsStringResArray.length > 0) {
            this.itemStringResArray = itemsStringResArray;
        }
        return this;
    }

    public Spinner items(String ... items) {
        if (items != null && items.length > 0) {
            this.items = items;
        }
        return this;
    }

    public Spinner preset(int itemIndex) {
        this.position = itemIndex;
        return this;
    }

    @Override
    public SpinnerViewHolder buildViewHolder() {
        return new SpinnerViewHolder(this);
    }

    @Nullable
    protected String getPlaceholderText(Context context) {
        if (this.placeholder != null) {
            return this.placeholder;
        }
        if (this.placeholderResourceId != -1) {
            return context.getString(this.placeholderResourceId);
        }
        return null;
    }

    @Nullable
    protected String[] getItems(Context context) {
        if (this.items != null) {
            return this.items;
        }
        if (this.itemStringResArray != null) {
            String[] s = new String[this.itemStringResArray.length];
            for (int i = 0; i < this.itemStringResArray.length; ++i) {
                s[i] = context.getString(this.itemStringResArray[i]);
            }
            return s;
        }
        if (this.itemArrayRes != -1) {
            return context.getResources().getStringArray(this.itemArrayRes);
        }
        return null;
    }

    protected Spinner(Parcel in) {
        super(in);
        this.itemArrayRes = in.readInt();
        this.itemStringResArray = in.createIntArray();
        this.items = in.createStringArray();
        this.placeholder = in.readString();
        this.placeholderResourceId = in.readInt();
        this.position = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.itemArrayRes);
        dest.writeIntArray(this.itemStringResArray);
        dest.writeStringArray(this.items);
        dest.writeString(this.placeholder);
        dest.writeInt(this.placeholderResourceId);
        dest.writeInt(this.position);
    }
}

