/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;
import eltos.simpledialogfragment.list.SimpleListItem;
import java.util.ArrayList;

public class SimpleListDialog
extends CustomListDialog<SimpleListDialog> {
    private static final String TAG = "simpleListDialog";
    protected static final String DATA_SET = "simpleListDialogdata_set";
    public static final String SELECTED_LABELS = "simpleListDialogselectedLabels";
    public static final String SELECTED_SINGLE_LABEL = "simpleListDialogselectedSingleLabel";
    public static final String HIGHLIGHT = "simpleListDialoghighlight";
    ArrayList<SimpleListItem> mData;

    public static SimpleListDialog build() {
        return new SimpleListDialog();
    }

    public SimpleListDialog items(Context context, @StringRes int[] labelsResourceIds) {
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labelsResourceIds.length);
        for (int id2 : labelsResourceIds) {
            list.add(new SimpleListItem(context.getString(id2), id2));
        }
        return this.items(list);
    }

    public SimpleListDialog items(Context context, @ArrayRes int labelArrayResourceIds) {
        return this.items(context.getResources().getStringArray(labelArrayResourceIds));
    }

    public SimpleListDialog items(String[] labels) {
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labels.length);
        for (String label : labels) {
            list.add(new SimpleListItem(label, label.hashCode()));
        }
        return this.items(list);
    }

    public SimpleListDialog items(String[] labels, long[] ids) {
        if (labels.length != ids.length) {
            throw new IllegalArgumentException("Length of ID-array must match label array length!");
        }
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labels.length);
        for (int i = 0; i < labels.length && i < ids.length; ++i) {
            list.add(new SimpleListItem(labels[i], ids[i]));
        }
        return this.items(list);
    }

    public SimpleListDialog items(ArrayList<SimpleListItem> items) {
        this.getArguments().putParcelableArrayList(DATA_SET, items);
        return this;
    }

    public SimpleListDialog filterable(boolean enabled, boolean highlight) {
        this.setArg(HIGHLIGHT, highlight);
        return (SimpleListDialog)((Object)super.filterable(enabled));
    }

    @Override
    protected SimpleListAdapter onCreateAdapter() {
        int layout2;
        switch (this.getArguments().getInt("CustomListDialogchoiceMode")) {
            case 1: {
                layout2 = 17367055;
                break;
            }
            case 2: {
                layout2 = 0x1090010;
                break;
            }
            default: {
                layout2 = 17367043;
            }
        }
        this.mData = this.getArguments().getParcelableArrayList(DATA_SET);
        if (this.mData == null) {
            this.mData = new ArrayList(0);
        }
        return new SimpleListAdapter(layout2, this.mData);
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle result = super.onResult(which);
        if (result != null) {
            ArrayList positions = result.getIntegerArrayList("CustomListDialogselectedPos");
            if (positions != null) {
                ArrayList<String> labels = new ArrayList<String>(positions.size());
                for (Integer pos : positions) {
                    labels.add(this.mData.get(pos).getString());
                }
                result.putStringArrayList(SELECTED_LABELS, labels);
            }
            if (result.containsKey("CustomListDialogselectedSinglePos")) {
                result.putString(SELECTED_SINGLE_LABEL, this.mData.get(result.getInt("CustomListDialogselectedSinglePos")).getString());
            }
        }
        return result;
    }

    class SimpleListAdapter
    extends AdvancedAdapter<String> {
        private int mLayout;
        AdvancedAdapter.AdvancedFilter mFilter = new AdvancedAdapter.AdvancedFilter(true, true){

            protected boolean matches(String object, @NonNull CharSequence constraint) {
                return this.matches(object);
            }
        };

        SimpleListAdapter(int layout2, ArrayList<SimpleListItem> data) {
            this.mLayout = layout2;
            ArrayList dataAndIds = new ArrayList(data.size());
            for (SimpleListItem simpleListItem : data) {
                dataAndIds.add(new Pair((Object)simpleListItem.getString(), (Object)simpleListItem.getId()));
            }
            this.setDataAndIds(dataAndIds);
        }

        @Override
        public AdvancedAdapter.AdvancedFilter getFilter() {
            return this.mFilter;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView textView;
            if (convertView == null) {
                convertView = SimpleListDialog.this.inflate(this.mLayout, parent, false);
                textView = (TextView)convertView.findViewById(16908308);
                convertView.setTag((Object)textView);
            } else {
                textView = (TextView)convertView.getTag();
            }
            if (SimpleListDialog.this.getArguments().getBoolean(SimpleListDialog.HIGHLIGHT)) {
                textView.setText((CharSequence)this.highlight((String)this.getItem(position), SimpleListDialog.this.getContext()));
            } else {
                textView.setText((CharSequence)this.getItem(position));
            }
            return super.getView(position, convertView, parent);
        }
    }
}

