/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.color.ColorView;
import eltos.simpledialogfragment.color.SimpleColorWheelDialog;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;

public class SimpleColorDialog
extends CustomListDialog<SimpleColorDialog>
implements SimpleDialog.OnDialogResultListener {
    private static final String TAG = "SimpleColorDialog";
    public static final String COLOR = "SimpleColorDialogcolor";
    public static final String COLORS = "SimpleColorDialogcolors";
    public static final int NONE = 0;
    protected static final int PICKER = -2;
    @ColorInt
    protected static final int[] DEFAULT_COLORS = new int[]{-769226, -1499549, -6543440, -10011977, -12627531, -14575885, -16537100, -16728876, -16738680, -11751600, -7617718, -3285959, -5317, -16121, -26624, -43230, -8825528, -6381922, -10453621};
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET = R.array.material_pallet;
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET_LIGHT = R.array.material_pallet_light;
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET_DARK = R.array.material_pallet_dark;
    @ArrayRes
    public static final int BEIGE_COLOR_PALLET = R.array.beige_pallet;
    @ArrayRes
    public static final int COLORFUL_COLOR_PALLET = R.array.colorful_pallet;
    protected static final String CUSTOM = "SimpleColorDialogcustom";
    protected static final String PICKER_DIALOG_TAG = "SimpleColorDialogpicker";
    private static final String SELECTED = "SimpleColorDialogselected";
    @ColorInt
    private int mCustomColor = 0;
    @ColorInt
    private int mSelectedColor = 0;

    public SimpleColorDialog() {
        this.grid();
        this.gridColumnWidth(R.dimen.dialog_color_item_size);
        this.choiceMode(1);
        this.choiceMin(1);
        this.colors(DEFAULT_COLORS);
    }

    public static SimpleColorDialog build() {
        return new SimpleColorDialog();
    }

    public SimpleColorDialog colors(@ColorInt int[] colors) {
        this.getArguments().putIntArray(COLORS, colors);
        return this;
    }

    public SimpleColorDialog colors(Context context, @ArrayRes int colorArrayRes) {
        return this.colors(context.getResources().getIntArray(colorArrayRes));
    }

    public SimpleColorDialog colorPreset(@ColorInt int color) {
        this.getArguments().putInt(COLOR, color);
        return this;
    }

    public SimpleColorDialog allowCustom(boolean allow) {
        return (SimpleColorDialog)this.setArg(CUSTOM, allow);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mCustomColor = savedInstanceState.getInt(CUSTOM, this.mCustomColor);
            this.mSelectedColor = savedInstanceState.getInt(SELECTED, this.mCustomColor);
        }
    }

    @Override
    protected AdvancedAdapter onCreateAdapter() {
        int[] colors = this.getArguments().getIntArray(COLORS);
        if (colors == null) {
            colors = new int[]{};
        }
        boolean custom = this.getArguments().getBoolean(CUSTOM);
        if (this.mSelectedColor == 0 && this.getArguments().containsKey(COLOR)) {
            int preset = this.getArguments().getInt(COLOR, 0);
            int index = this.indexOf(colors, preset);
            if (index < 0) {
                this.mSelectedColor = this.mCustomColor = preset;
                if (custom) {
                    this.choicePreset(colors.length);
                }
            } else {
                this.choicePreset(index);
                this.mSelectedColor = preset;
            }
        }
        this.getListView().setSelector((Drawable)new ColorDrawable(0));
        return new ColorAdapter(colors, custom);
    }

    private int indexOf(int[] array2, int item) {
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(CUSTOM, this.mCustomColor);
        outState.putInt(SELECTED, this.mSelectedColor);
        super.onSaveInstanceState(outState);
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        if (this.getArguments().getInt("CustomListDialogchoiceMode") == 11) {
            return this.mSelectedColor != 0;
        }
        return true;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (id2 == -2L) {
            SimpleColorWheelDialog dialog = ((SimpleColorWheelDialog)((Object)SimpleColorWheelDialog.build().theme(this.getTheme()))).alpha(false);
            if (this.mCustomColor != 0) {
                dialog.color(this.mCustomColor);
            } else if (this.mSelectedColor != 0) {
                dialog.color(this.mSelectedColor);
                this.mCustomColor = this.mSelectedColor;
            }
            dialog.show((Fragment)this, PICKER_DIALOG_TAG);
            this.mSelectedColor = 0;
        } else {
            this.mSelectedColor = (int)id2;
        }
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        if (PICKER_DIALOG_TAG.equals(dialogTag) && which == -1) {
            this.mSelectedColor = this.mCustomColor = extras.getInt("SimpleColorWheelDialog.color");
            this.notifyDataSetChanged();
            if (this.getArguments().getInt("CustomListDialogchoiceMode") == 11) {
                this.pressPositiveButton();
            }
            return true;
        }
        return false;
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle b = super.onResult(which);
        int color = (int)b.getLong("CustomListDialogselectedSingleId");
        if (color == -2) {
            b.putInt(COLOR, this.mCustomColor);
        } else {
            b.putInt(COLOR, color);
        }
        long[] ids = b.getLongArray("CustomListDialogselectedIds");
        if (ids != null) {
            int[] colors = new int[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                colors[i] = ids[i] == -2L ? this.mCustomColor : (int)ids[i];
            }
            b.putIntArray(COLORS, colors);
        }
        return b;
    }

    protected class ColorAdapter
    extends AdvancedAdapter<Integer> {
        public ColorAdapter(int[] colors, boolean addCustomField) {
            if (colors == null) {
                colors = new int[]{};
            }
            Integer[] cs = new Integer[colors.length + (addCustomField ? 1 : 0)];
            for (int i = 0; i < colors.length; ++i) {
                cs[i] = colors[i];
            }
            if (addCustomField) {
                cs[cs.length - 1] = -2;
            }
            this.setData(cs, new AdvancedAdapter.ItemIdentifier<Integer>(){

                @Override
                @Nullable
                public Long getIdForItem(Integer color) {
                    return (long)color;
                }
            });
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ColorView item = convertView instanceof ColorView ? (ColorView)convertView : new ColorView(SimpleColorDialog.this.getContext());
            int color = (Integer)this.getItem(position);
            if (color == -2) {
                item.setColor(SimpleColorDialog.this.mCustomColor);
                item.setStyle(ColorView.Style.PALETTE);
            } else {
                item.setColor((Integer)this.getItem(position));
                item.setStyle(ColorView.Style.CHECK);
            }
            return super.getView(position, (View)item, parent);
        }
    }
}

