/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Checkable;
import android.widget.FrameLayout;
import android.widget.ImageView;
import eltos.simpledialogfragment.R;

class ColorView
extends FrameLayout
implements Checkable {
    public static final int NONE = 0;
    @ColorInt
    private int mColor;
    private boolean mChecked = false;
    private int mOutlineWidth = 0;
    private ImageView mCheckView;
    private FrameLayout mColorView;
    private FrameLayout mRippleView;
    private final Animation showAnim;
    private final Animation hideAnim;
    private Style mStyle = Style.CHECK;
    private Drawable mDarkRippleDrawable;
    private Drawable mLightRippleDrawable;

    public ColorView(Context context) {
        this(context, null);
    }

    public ColorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.showAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.zoom_show);
        this.hideAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.zoom_out);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.simpledialogfragment_color_item, (ViewGroup)this, true);
        this.mCheckView = (ImageView)this.findViewById(R.id.checkmark);
        this.mColorView = (FrameLayout)this.findViewById(R.id.color);
        this.mRippleView = (FrameLayout)this.findViewById(R.id.ripple);
        this.update();
    }

    public void setStyle(Style style2) {
        if (this.mStyle != style2) {
            this.mStyle = style2;
            this.update();
        }
    }

    @ColorInt
    public int getColor() {
        return this.mColor;
    }

    public void setColor(@ColorInt int color) {
        if ((color & 0xFF000000) == 0 && color != 0) {
            color |= 0xFF000000;
        }
        if (this.mColor != color) {
            this.mColor = color;
            this.update();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, true);
    }

    public void setChecked(boolean checked, boolean animate) {
        switch (this.mStyle) {
            case CHECK: {
                if (animate) {
                    if (!this.mChecked && checked) {
                        this.mCheckView.startAnimation(this.showAnim);
                    } else if (this.mChecked && !checked) {
                        this.mCheckView.startAnimation(this.hideAnim);
                    }
                }
                this.mCheckView.setVisibility(checked ? 0 : 4);
                break;
            }
            case PALETTE: {
                if (animate) {
                    if (!this.mChecked && checked) {
                        this.mColorView.startAnimation(this.showAnim);
                    } else if (this.mChecked && !checked) {
                        this.mColorView.startAnimation(this.hideAnim);
                    }
                }
                this.mColorView.setVisibility(checked ? 0 : 4);
                if (this.mColor != 0) {
                    this.mCheckView.setColorFilter(checked ? (ColorView.isColorDark(this.mColor) ? -1 : -16777216) : this.mColor);
                } else {
                    this.mCheckView.setColorFilter(null);
                }
                this.mRippleView.setForeground(checked ? this.mDarkRippleDrawable : this.mLightRippleDrawable);
            }
        }
        this.mChecked = checked;
    }

    public void setOutlineWidth(int width) {
        this.mOutlineWidth = width;
        this.update();
    }

    private void update() {
        this.setForeground(null);
        if (Build.VERSION.SDK_INT < 16) {
            this.mColorView.setBackgroundDrawable(this.createBackgroundColorDrawable());
        } else {
            this.mColorView.setBackground(this.createBackgroundColorDrawable());
        }
        switch (this.mStyle) {
            case CHECK: {
                this.mCheckView.setImageResource(R.drawable.ic_check_white);
                this.mCheckView.setColorFilter(ColorView.isColorDark(this.mColor) ? -1 : -16777216);
                this.mColorView.setVisibility(0);
                this.mRippleView.setForeground(this.createRippleDrawable(ColorView.getDarkRippleColor(this.mColor)));
                break;
            }
            case PALETTE: {
                this.mCheckView.setImageResource(this.mColor != 0 ? R.drawable.ic_palette_white : R.drawable.ic_palette_color);
                this.mCheckView.setVisibility(0);
                this.mDarkRippleDrawable = this.createRippleDrawable(ColorView.getDarkRippleColor(this.mColor));
                this.mLightRippleDrawable = this.createRippleDrawable(ColorView.getLightRippleColor(this.mColor));
            }
        }
        this.setChecked(this.mChecked, false);
    }

    private Drawable createBackgroundColorDrawable() {
        GradientDrawable mask = new GradientDrawable();
        mask.setShape(1);
        if (this.mOutlineWidth != 0) {
            mask.setStroke(this.mOutlineWidth, ColorView.isColorDark(this.mColor) ? -1 : -16777216);
        }
        mask.setColor(this.mColor);
        return mask;
    }

    private Drawable createRippleDrawable(int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            GradientDrawable mask = new GradientDrawable();
            mask.setShape(1);
            mask.setColor(-16777216);
            return new RippleDrawable(ColorStateList.valueOf((int)color), null, (Drawable)mask);
        }
        StateListDrawable foreground = new StateListDrawable();
        foreground.setAlpha(80);
        foreground.setEnterFadeDuration(250);
        foreground.setExitFadeDuration(250);
        GradientDrawable mask = new GradientDrawable();
        mask.setShape(1);
        mask.setColor(color);
        foreground.addState(new int[]{16842919}, (Drawable)mask);
        foreground.addState(new int[0], (Drawable)new ColorDrawable(0));
        return foreground;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
    }

    public static boolean isColorDark(@ColorInt int color) {
        double brightness = (double)Color.red((int)color) * 0.299 + (double)Color.green((int)color) * 0.587 + (double)Color.blue((int)color) * 0.114;
        return brightness < 180.0;
    }

    @ColorInt
    public static int getDarkRippleColor(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * 0.5f;
        return Color.HSVToColor((float[])hsv);
    }

    @ColorInt
    public static int getLightRippleColor(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = hsv[1] * 0.5f;
        hsv[2] = 1.0f - (1.0f - hsv[2]) * 0.5f;
        return Color.HSVToColor((float[])hsv);
    }

    static enum Style {
        CHECK,
        PALETTE;

    }
}

