/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.form.FormElement;
import eltos.simpledialogfragment.form.InputViewHolder;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Input
extends FormElement<Input, InputViewHolder> {
    private static final int NO_ID = -1;
    private String hint = null;
    private int hintResourceId = -1;
    private String text = null;
    private int textResourceId = -1;
    int inputType = 1;
    int maxLength = -1;
    int minLength = -1;
    private int suggestionArrayRes = -1;
    private int[] suggestionStringResArray = null;
    private String[] suggestions = null;
    boolean passwordToggleVisible;
    boolean forceSuggestion = false;
    String pattern = null;
    private String patternError = null;
    private int patternErrorId = -1;
    private Pattern compiledPattern = null;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String STRONG_PW_PATTERN = "^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[@%_/'!&#:;,<>=~\"\\|\\*\\+\\-\\$\\^\\?\\.\\(\\)\\{\\}\\[\\]\\\\])(?=\\S+$).*$";
    private static final String LETTERS_PATTERN = "^[a-zA-Z]*$";
    private static final String ALPHANUMERIC_PATTERN = "^[a-zA-Z0-9]*$";
    public static final Parcelable.Creator<Input> CREATOR = new Parcelable.Creator<Input>(){

        public Input createFromParcel(Parcel in) {
            return new Input(in);
        }

        public Input[] newArray(int size) {
            return new Input[size];
        }
    };

    private Input(String key) {
        super(key);
    }

    public static Input plain(String key) {
        return new Input(key);
    }

    public static Input name(String key) {
        return new Input(key).inputType(8193).hint(R.string.name);
    }

    public static Input password(String key) {
        return new Input(key).inputType(129).showPasswordToggle().hint(R.string.password);
    }

    public static Input email(String key) {
        return new Input(key).inputType(33).validatePatternEmail().hint(R.string.email_address);
    }

    public static Input phone(String key) {
        return new Input(key).inputType(3).hint(R.string.phone_number);
    }

    public Input hint(String hint) {
        this.hint = hint;
        return this;
    }

    public Input hint(@StringRes int hintResourceId) {
        this.hintResourceId = hintResourceId;
        return this;
    }

    public Input text(String text) {
        this.text = text;
        return this;
    }

    public Input text(@StringRes int textResourceId) {
        this.textResourceId = textResourceId;
        return this;
    }

    public Input inputType(int inputType) {
        this.inputType = inputType;
        return this;
    }

    public Input showPasswordToggle() {
        return this.showPasswordToggle(true);
    }

    public Input showPasswordToggle(boolean show) {
        this.passwordToggleVisible = show;
        return this;
    }

    public Input max(@IntRange(from=1L) int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Input min(@IntRange(from=1L) int minLength) {
        this.minLength = minLength;
        return this;
    }

    public Input suggest(@ArrayRes int suggestionArrayRes) {
        this.suggestionArrayRes = suggestionArrayRes;
        return this;
    }

    public Input suggest(int ... suggestionStringResArray) {
        if (suggestionStringResArray != null && suggestionStringResArray.length > 0) {
            this.suggestionStringResArray = suggestionStringResArray;
        }
        return this;
    }

    public Input suggest(String ... strings) {
        if (strings != null && strings.length > 0) {
            this.suggestions = strings;
        }
        return this;
    }

    public Input suggest(ArrayList<String> strings) {
        if (strings != null && strings.size() > 0) {
            return this.suggest(strings.toArray(new String[strings.size()]));
        }
        return this;
    }

    public Input forceSuggestion() {
        return this.forceSuggestion(true);
    }

    public Input forceSuggestion(boolean force) {
        this.forceSuggestion = force;
        return this;
    }

    public Input validatePattern(String pattern, @Nullable String errorMsg) {
        this.pattern = pattern;
        this.patternError = errorMsg;
        return this;
    }

    public Input validatePattern(String pattern, @StringRes int errorMsgId) {
        this.pattern = pattern;
        this.patternErrorId = errorMsgId;
        return this;
    }

    public Input validatePatternEmail() {
        return this.validatePattern(EMAIL_PATTERN, R.string.invalid_email_address);
    }

    public Input validatePatternStrongPassword() {
        if (this.minLength < 8) {
            this.min(8);
        }
        return this.validatePattern(STRONG_PW_PATTERN, R.string.strong_pw_requirements);
    }

    public Input validatePatternLetters() {
        return this.validatePattern(LETTERS_PATTERN, R.string.letters_only_error);
    }

    public Input validatePatternAlphanumeric() {
        return this.validatePattern(ALPHANUMERIC_PATTERN, R.string.alphanumeric_only_error);
    }

    @Override
    public InputViewHolder getViewHolder() {
        return new InputViewHolder(this);
    }

    protected String validatePattern(Context context, @Nullable String input) {
        if (this.pattern != null && input != null) {
            if (this.compiledPattern == null) {
                this.compiledPattern = Pattern.compile(this.pattern);
            }
            if (!this.compiledPattern.matcher(input).matches()) {
                return this.getPatternError(context);
            }
        }
        return null;
    }

    @Nullable
    protected String getPatternError(Context context) {
        if (this.patternError != null) {
            return this.patternError;
        }
        if (this.patternErrorId != -1) {
            return context.getString(this.patternErrorId);
        }
        return null;
    }

    @Nullable
    protected String getHint(Context context) {
        if (this.hint != null) {
            return this.hint;
        }
        if (this.hintResourceId != -1) {
            return context.getString(this.hintResourceId);
        }
        return null;
    }

    @Nullable
    protected String getText(Context context) {
        if (this.text != null) {
            return this.text;
        }
        if (this.textResourceId != -1) {
            return context.getString(this.textResourceId);
        }
        return null;
    }

    @Nullable
    protected String[] getSuggestions(Context context) {
        if (this.suggestions != null) {
            return this.suggestions;
        }
        if (this.suggestionStringResArray != null) {
            String[] s = new String[this.suggestionStringResArray.length];
            for (int i = 0; i < this.suggestionStringResArray.length; ++i) {
                s[i] = context.getString(this.suggestionStringResArray[i]);
            }
            return s;
        }
        if (this.suggestionArrayRes != -1) {
            return context.getResources().getStringArray(this.suggestionArrayRes);
        }
        return null;
    }

    private Input(Parcel in) {
        super(in);
        this.hint = in.readString();
        this.hintResourceId = in.readInt();
        this.text = in.readString();
        this.textResourceId = in.readInt();
        this.inputType = in.readInt();
        this.maxLength = in.readInt();
        this.minLength = in.readInt();
        this.suggestionArrayRes = in.readInt();
        this.suggestionStringResArray = in.createIntArray();
        this.suggestions = in.createStringArray();
        this.passwordToggleVisible = in.readByte() != 0;
        this.forceSuggestion = in.readByte() != 0;
        this.pattern = in.readString();
        this.patternError = in.readString();
        this.patternErrorId = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.hint);
        dest.writeInt(this.hintResourceId);
        dest.writeString(this.text);
        dest.writeInt(this.textResourceId);
        dest.writeInt(this.inputType);
        dest.writeInt(this.maxLength);
        dest.writeInt(this.minLength);
        dest.writeInt(this.suggestionArrayRes);
        dest.writeIntArray(this.suggestionStringResArray);
        dest.writeStringArray(this.suggestions);
        dest.writeByte((byte)(this.passwordToggleVisible ? 1 : 0));
        dest.writeByte((byte)(this.forceSuggestion ? 1 : 0));
        dest.writeString(this.pattern);
        dest.writeString(this.patternError);
        dest.writeInt(this.patternErrorId);
    }
}

