/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.os.Bundle;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.TextView;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class CustomListDialog<This extends CustomListDialog<This>>
extends CustomViewDialog<This>
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = "CustomListDialog";
    public static final int NO_CHOICE = 0;
    public static final int SINGLE_CHOICE = 1;
    public static final int SINGLE_CHOICE_DIRECT = 11;
    public static final int MULTI_CHOICE = 2;
    public static final String SELECTED_IDS = "CustomListDialogselectedIds";
    public static final String SELECTED_POSITIONS = "CustomListDialogselectedPos";
    public static final String SELECTED_SINGLE_ID = "CustomListDialogselectedSingleId";
    public static final String SELECTED_SINGLE_POSITION = "CustomListDialogselectedSinglePos";
    protected static final String CHOICE_MODE = "CustomListDialogchoiceMode";
    protected static final String CHOICE_MIN_COUNT = "CustomListDialogchoiceMin";
    protected static final String CHOICE_MAX_COUNT = "CustomListDialogchoiceMax";
    protected static final String INITIALLY_CHECKED_POSITIONS = "CustomListDialoginitCheckPos";
    protected static final String INITIALLY_CHECKED_IDS = "CustomListDialoginitCheckId";
    private static final String GRID = "CustomListDialoggrid";
    private static final String GRID_N = "CustomListDialoggridN";
    private static final String GRID_W = "CustomListDialoggridW";
    private static final String SHOW_DIVIDER = "CustomListDialogshowDivider";
    private static final String FILTER = "CustomListDialogfilter";
    private static final String EMPTY_TEXT = "CustomListDialogemptyText";
    private boolean pmFlag = false;
    private AbsListView mListView;
    private AdvancedAdapter<?> mAdapter;
    private EditText mFilterEditText;

    protected abstract AdvancedAdapter onCreateAdapter();

    public This choiceMode(int mode) {
        if (!this.pmFlag && mode == 11) {
            this.pos(null);
        }
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MODE, mode))));
    }

    public This choiceMin(int count) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MIN_COUNT, count))));
    }

    public This choiceMax(int count) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MAX_COUNT, count))));
    }

    public This choicePreset(List<Integer> positions) {
        int[] p = new int[positions.size()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = positions.get(i);
        }
        return this.choicePreset(p);
    }

    public This choicePreset(int[] positions) {
        this.getArguments().putIntArray(INITIALLY_CHECKED_POSITIONS, positions);
        return (This)((Object)this);
    }

    public This choicePreset(int position) {
        return this.choicePreset(new int[]{position});
    }

    public This choiceIdPreset(List<Long> ids) {
        long[] p = new long[ids.size()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = ids.get(i);
        }
        return this.choiceIdPreset(p);
    }

    public This choiceIdPreset(long[] ids) {
        this.getArguments().putLongArray(INITIALLY_CHECKED_IDS, ids);
        return (This)((Object)this);
    }

    public This choiceIdPreset(long id2) {
        return this.choiceIdPreset(new long[]{id2});
    }

    public This grid() {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(GRID, true))));
    }

    public This gridNumColumn(int numColumns) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(GRID_N, numColumns))));
    }

    public This gridColumnWidth(@DimenRes int columnWidthDimenResId) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(GRID_W, columnWidthDimenResId))));
    }

    public This divider(boolean show) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(SHOW_DIVIDER, show))));
    }

    public This filterable(boolean enabled) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(FILTER, enabled))));
    }

    public This emptyText(String title) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(EMPTY_TEXT, title))));
    }

    public This emptyText(@StringRes int titleResourceId) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(EMPTY_TEXT, titleResourceId))));
    }

    @Override
    public This pos(String positiveButton) {
        this.pmFlag = true;
        return (This)((Object)((CustomListDialog)((Object)super.pos(positiveButton))));
    }

    @Override
    public This pos(int positiveButtonResourceId) {
        this.pmFlag = true;
        return (This)((Object)((CustomListDialog)((Object)super.pos(positiveButtonResourceId))));
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        return false;
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        View view;
        block14: {
            block13: {
                int[] set;
                if (this.getArguments().containsKey(GRID)) {
                    view = this.inflate(R.layout.dialog_grid);
                    this.mListView = (GridView)view.findViewById(R.id.gridView);
                    if (this.getArguments().containsKey(GRID_W)) {
                        ((GridView)this.mListView).setColumnWidth(this.getResources().getDimensionPixelSize(this.getArguments().getInt(GRID_W)));
                    }
                    ((GridView)this.mListView).setNumColumns(this.getArguments().getInt(GRID_N, -1));
                } else {
                    view = this.inflate(R.layout.dialog_list);
                    this.mListView = (ListView)view.findViewById(R.id.listView);
                }
                this.mFilterEditText = (EditText)view.findViewById(R.id.filter);
                TextView mEmptyView = (TextView)view.findViewById(R.id.emptyView);
                mEmptyView.setText((CharSequence)this.getArgString(EMPTY_TEXT));
                this.mAdapter = this.onCreateAdapter();
                this.mListView.setAdapter(this.mAdapter);
                this.mListView.setEmptyView((View)mEmptyView);
                switch (this.getArguments().getInt(CHOICE_MODE, 0)) {
                    case 1: 
                    case 11: {
                        this.mAdapter.setChoiceMode(1);
                        break;
                    }
                    case 2: {
                        this.mAdapter.setChoiceMode(2);
                    }
                }
                this.mFilterEditText.setVisibility(8);
                if (this.getArguments().getBoolean(FILTER)) {
                    this.mFilterEditText.setVisibility(0);
                    this.mFilterEditText.addTextChangedListener(new TextWatcher(){

                        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                        }

                        public void onTextChanged(CharSequence s, int start, int before, int count) {
                        }

                        public void afterTextChanged(Editable s) {
                            if (CustomListDialog.this.mAdapter.getFilter() != null) {
                                CustomListDialog.this.mAdapter.getFilter().filter((CharSequence)s);
                            }
                        }
                    });
                }
                this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        CustomListDialog.this.onItemClick(parent, view, position, id2);
                        CustomListDialog.this.mAdapter.toggleChecked(position);
                        CustomListDialog.this.mAdapter.notifyDataSetChanged();
                        CustomListDialog.this.updatePosButton();
                        if (CustomListDialog.this.mAdapter.getCheckedItemCount() > 0 && CustomListDialog.this.getArguments().getInt(CustomListDialog.CHOICE_MODE) == 11) {
                            CustomListDialog.this.pressPositiveButton();
                        }
                    }
                });
                this.mListView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
                if (this.mListView instanceof ListView && !this.getArguments().getBoolean(SHOW_DIVIDER)) {
                    ((ListView)this.mListView).setDivider(null);
                }
                if (savedInstanceState != null) break block13;
                if (this.getArguments().containsKey(INITIALLY_CHECKED_IDS)) {
                    long[] idSet = this.getArguments().getLongArray(INITIALLY_CHECKED_IDS);
                    this.mAdapter.setItemsCheckedFromIds(idSet);
                }
                if (!this.getArguments().containsKey(INITIALLY_CHECKED_POSITIONS) || (set = this.getArguments().getIntArray(INITIALLY_CHECKED_POSITIONS)) == null) break block14;
                for (int i : set) {
                    this.mAdapter.setItemChecked(i, true);
                }
                break block14;
            }
            ArrayList checked = savedInstanceState.getIntegerArrayList(SELECTED_POSITIONS);
            if (checked != null) {
                for (Integer i : checked) {
                    this.mAdapter.setItemChecked(i, true);
                }
            }
        }
        return view;
    }

    protected AbsListView getListView() {
        return this.mListView;
    }

    protected void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    protected void onDialogShown() {
        this.updatePosButton();
        if (this.getArguments().getBoolean(FILTER)) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.mFilterEditText, 1);
        }
    }

    private void updatePosButton() {
        if (this.getArguments().getInt(CHOICE_MODE) == 0) {
            this.setPositiveButtonEnabled(true);
        } else {
            int min = this.getArguments().getInt(CHOICE_MIN_COUNT, -1);
            int max = this.getArguments().getInt(CHOICE_MAX_COUNT, -1);
            this.setPositiveButtonEnabled(!(min >= 0 && this.mAdapter.getCheckedItemCount() < min || max >= 0 && this.mAdapter.getCheckedItemCount() > max));
        }
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle result = new Bundle();
        ArrayList<Integer> checked = this.mAdapter.getCheckedItemOriginalPositions();
        ArrayList<Long> checkedIds = this.mAdapter.getCheckedItemIds();
        if (this.getArguments().getInt(CHOICE_MODE) != 0) {
            result.putIntegerArrayList(SELECTED_POSITIONS, checked);
            long[] checkedIdsArray = new long[checkedIds.size()];
            for (int i = 0; i < checkedIdsArray.length; ++i) {
                checkedIdsArray[i] = checkedIds.get(i);
            }
            result.putLongArray(SELECTED_IDS, checkedIdsArray);
        }
        if (this.getArguments().getInt(CHOICE_MODE) == 1 || this.getArguments().getInt(CHOICE_MODE) == 11) {
            if (checked.size() >= 1) {
                result.putInt(SELECTED_SINGLE_POSITION, checked.get(0).intValue());
            }
            if (checkedIds.size() >= 1) {
                result.putLong(SELECTED_SINGLE_ID, checkedIds.get(0).longValue());
            }
        }
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putIntegerArrayList(SELECTED_POSITIONS, this.mAdapter.getCheckedItemOriginalPositions());
        super.onSaveInstanceState(outState);
    }
}

