/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;

public class ColorWheelView
extends View {
    public static int DEFAULT_COLOR = -3193017;
    private OnColorChangeListener mListener;
    private TriangleWithSuggestions triangle;
    private Rainbow rainbow;
    private final RectF circleBox = new RectF();
    private final Paint colorPaint = new Paint(1);
    private C myColor = new C(DEFAULT_COLOR);
    private Touch touch = Touch.NONE;

    public ColorWheelView(Context context) {
        this(context, null);
    }

    public ColorWheelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorWheelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.triangle = new TriangleWithSuggestions();
        this.rainbow = new Rainbow();
    }

    public void setColor(int color) {
        this.setColor(color, true);
    }

    public void setColor(int color, boolean callListener) {
        this.setColorInternal(new C(color), callListener);
    }

    public void updateAlpha(int alpha) {
        this.updateAlpha(alpha, true);
    }

    public void updateAlpha(int alpha, boolean callListener) {
        C newC = new C(this.myColor);
        newC.alpha(alpha);
        this.setColorInternal(newC, callListener);
    }

    public int getColor() {
        return this.myColor.rgba();
    }

    public void setOnColorChangeListener(OnColorChangeListener listener) {
        this.mListener = listener;
    }

    private void setColorInternal(C color) {
        this.setColorInternal(color, true);
    }

    private void setColorInternal(C color, boolean callListener) {
        boolean hsvChanged = !this.myColor.equalHSV(color);
        boolean changed = !this.myColor.equalAlphaHSV(color);
        this.myColor = color;
        this.triangle.setColor(this.myColor);
        this.triangle.setRotation(this.myColor.hue());
        this.triangle.invalidate();
        this.rainbow.setColor(this.myColor);
        this.colorPaint.setColor(this.myColor.rgba());
        if (hsvChanged) {
            this.invalidate();
        }
        if (changed && this.mListener != null && callListener) {
            this.mListener.onColorChange(this.getColor());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Keep keep = Keep.WIDTH;
        int desiredHeight = (int)this.dp(50);
        if (this.getLayoutParams().height == -1) {
            desiredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            keep = Keep.HEIGHT;
        }
        int desiredWidth = (int)this.dp(50);
        if (this.getLayoutParams().width == -1) {
            desiredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            keep = Keep.WIDTH;
        }
        int size = keep == Keep.HEIGHT ? desiredHeight : desiredWidth;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) {
            int widthLimited = View.MeasureSpec.getSize((int)widthMeasureSpec);
            size = Math.min(size, widthLimited);
        }
        if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) == 0x40000000 || heightMode == Integer.MIN_VALUE) {
            int heightLimited = View.MeasureSpec.getSize((int)heightMeasureSpec);
            size = Math.min(size, heightLimited);
        }
        this.setMeasuredDimension(size, size);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float size = Math.max(this.dp(20), Math.min(this.dp(35), this.dp(30) * (float)Math.min(w, h) / 1000.0f));
        float padding = Math.max(this.dp(5), Math.min(this.dp(10), this.dp(7) * (float)Math.min(w, h) / 1000.0f));
        PointF center = new PointF((float)(w / 2), (float)(h / 2));
        float radius = ((float)Math.min(w, h) - padding - size) / 2.0f;
        this.rainbow.setGeometry(center, radius, size);
        this.triangle.setGeometry(center, radius - size / 2.0f, padding);
        this.triangle.invalidate();
        this.circleBox.set(center.x - radius, center.y - radius, center.x + radius, center.y + radius);
        this.colorPaint.setStyle(Paint.Style.FILL);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean handled = false;
        PointF pointer = new PointF(event.getX(), event.getY());
        if (event.getAction() == 0) {
            if (this.rainbow.encloses(pointer)) {
                this.touch = Touch.HUE;
                this.setColorInternal(new C(this.myColor).hue(this.rainbow.hueAt(pointer)));
                handled = true;
            } else if (this.triangle.encloses(pointer)) {
                this.touch = Touch.TRIANGLE;
                this.setColorInternal(this.triangle.colorAt(pointer));
                handled = true;
            } else if (this.triangle.suggestionTouched(pointer) != null) {
                this.touch = Touch.SUGGESTION;
                handled = true;
            }
        } else if (event.getAction() == 2) {
            if (this.touch == Touch.HUE) {
                this.setColorInternal(new C(this.myColor).hue(this.rainbow.hueAt(pointer)));
                handled = true;
            } else if (this.touch == Touch.TRIANGLE) {
                this.setColorInternal(this.triangle.colorAt(pointer));
                handled = true;
            } else if (this.touch == Touch.SUGGESTION) {
                if (this.triangle.suggestionTouched(pointer) == null) {
                    this.touch = Touch.NONE;
                }
                handled = true;
            }
        } else if (event.getAction() == 1) {
            C c;
            if (this.touch == Touch.SUGGESTION && (c = this.triangle.suggestionTouched(pointer)) != null) {
                this.setColorInternal(c);
            }
            this.touch = Touch.NONE;
            handled = true;
        }
        if (handled) {
            if (this.getParent() != null && event.getAction() == 0) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.saveColor = this.myColor.hsv;
        ss.saveAlpha = this.myColor.alpha;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.myColor = new C(ss.saveAlpha, (int)ss.saveColor[0], ss.saveColor[1], ss.saveColor[2]);
    }

    private float dp(int value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float mod(float i, float m) {
        return (i % m + m) % m;
    }

    protected void onDraw(Canvas canvas) {
        this.triangle.draw(canvas);
        this.rainbow.draw(canvas);
    }

    private boolean between(float lowAngle, float angle, float highAngle) {
        lowAngle = this.mod(lowAngle, 360.0f);
        angle = this.mod(angle, 360.0f);
        if (lowAngle < (highAngle = this.mod(highAngle, 360.0f))) {
            return lowAngle <= angle && angle <= highAngle;
        }
        return lowAngle <= angle || angle <= highAngle;
    }

    private class Rainbow {
        private RectF boundingBox = new RectF();
        private PointF center = new PointF();
        private float radius = 0.0f;
        private float with = 0.0f;
        private C mColor = new C(-16777216);
        private final Paint paint;
        private final Paint markerPaint;
        private float[] marker = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

        Rainbow() {
            this.paint = new Paint(1);
            this.paint.setStyle(Paint.Style.STROKE);
            this.markerPaint = new Paint(1);
            this.markerPaint.setStyle(Paint.Style.STROKE);
            this.markerPaint.setStrokeWidth(ColorWheelView.this.dp(1));
        }

        void setGeometry(PointF center, float radius, float with) {
            this.center = center;
            this.radius = radius;
            this.with = with;
            this.paint.setStrokeWidth(with);
            this.boundingBox = new RectF(center.x - radius, center.y - radius, center.x + radius, center.y + radius);
            this.updateShader();
            this.updateMarker();
        }

        void setColor(C color) {
            if (this.mColor.hue() != color.hue()) {
                this.mColor = color;
                this.updateMarker();
            }
            this.mColor = color;
        }

        private void updateShader() {
            int[] gradient = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
            SweepGradient rainbow = new SweepGradient(this.center.x, this.center.y, gradient, null);
            this.paint.setShader((Shader)rainbow);
        }

        private void updateMarker() {
            this.markerPaint.setColor(new C(255, this.mColor.hue(), 1.0f, 1.0f).inverted().rgb());
            float sx = (float)Math.cos(Math.toRadians(this.mColor.hue()));
            float sy = (float)Math.sin(Math.toRadians(this.mColor.hue()));
            this.marker = new float[]{this.center.x + (this.radius - this.with / 3.0f) * sx, this.center.y + (this.radius - this.with / 3.0f) * sy, this.center.x + (this.radius + this.with / 3.0f) * sx, this.center.y + (this.radius + this.with / 3.0f) * sy};
        }

        void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(-90.0f, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
            canvas.drawArc(this.boundingBox, 0.0f, 360.0f, false, this.paint);
            canvas.drawLines(this.marker, this.markerPaint);
            canvas.restore();
        }

        boolean encloses(PointF pointer) {
            double r = Math.sqrt(Math.pow(pointer.x - this.center.x, 2.0) + Math.pow(pointer.y - this.center.y, 2.0));
            return (double)(this.radius - this.with) <= r && r <= (double)(this.radius + this.with);
        }

        int hueAt(PointF pointer) {
            return (int)ColorWheelView.this.mod((float)(Math.toDegrees(Math.atan2(pointer.y - this.center.y, pointer.x - this.center.x)) + 90.0), 360.0f);
        }
    }

    private class Triangle {
        PointF mCenter = new PointF();
        float mRadius = 0.0f;
        float mPadding = 0.0f;
        int mRotation = 0;
        C mColor = new C(-16777216);
        boolean geometryNeedsUpdate = true;
        boolean rotationNeedsUpdate = true;
        boolean colorHueChanged = true;
        boolean colorHsvChanged = true;
        boolean colorNeedsUpdate = true;
        private PointF A = new PointF();
        private PointF B = new PointF();
        private PointF C = new PointF();
        protected Path path = new Path();
        private final Paint paint;
        private final Paint dotPaint;
        private float dotSize = 0.0f;
        private PointF dot = new PointF();

        Triangle() {
            this.dotSize = ColorWheelView.this.dp(4);
            float marker = ColorWheelView.this.dp(1);
            this.paint = new Paint(1);
            this.paint.setStyle(Paint.Style.FILL);
            this.dotPaint = new Paint(1);
            this.dotPaint.setStyle(Paint.Style.STROKE);
            this.dotPaint.setStrokeWidth(marker);
            ColorWheelView.this.setLayerType(1, null);
        }

        void setGeometry(PointF center, float radius, float padding) {
            if (!this.mCenter.equals((Object)center) || radius != this.mRadius || padding != this.mPadding) {
                this.geometryNeedsUpdate = true;
            }
            this.mCenter = center;
            this.mRadius = radius;
            this.mPadding = padding;
        }

        void setRotation(int rotation) {
            if (this.mRotation != rotation) {
                this.rotationNeedsUpdate = true;
            }
            this.mRotation = rotation;
        }

        public void setColor(C color) {
            if (!this.mColor.equalAlphaHSV(color)) {
                this.colorNeedsUpdate = true;
            }
            this.colorHsvChanged |= !this.mColor.equalHSV(color);
            this.colorHueChanged |= this.mColor.hue() != color.hue();
            this.mColor = color;
        }

        void invalidate() {
            if (this.geometryNeedsUpdate) {
                this.updateGeometryDependant();
            }
            if (this.geometryNeedsUpdate || this.rotationNeedsUpdate) {
                this.updateRotationDependant();
            }
            if (this.geometryNeedsUpdate || this.rotationNeedsUpdate || this.colorNeedsUpdate) {
                this.updateColorDependant(this.geometryNeedsUpdate || this.rotationNeedsUpdate || this.colorHsvChanged, this.geometryNeedsUpdate || this.rotationNeedsUpdate || this.colorHueChanged);
            }
            this.geometryNeedsUpdate = false;
            this.rotationNeedsUpdate = false;
            this.colorHueChanged = false;
            this.colorHsvChanged = false;
            this.colorNeedsUpdate = false;
        }

        protected void updateGeometryDependant() {
        }

        protected void updateRotationDependant() {
            this.A.set(this.mCenter.x + (this.mRadius - this.mPadding) * (float)Math.cos(Math.toRadians(this.mRotation - 90)), this.mCenter.y + (this.mRadius - this.mPadding) * (float)Math.sin(Math.toRadians(this.mRotation - 90)));
            this.B.set(this.mCenter.x + (this.mRadius - this.mPadding) * (float)Math.cos(Math.toRadians(this.mRotation + 30)), this.mCenter.y + (this.mRadius - this.mPadding) * (float)Math.sin(Math.toRadians(this.mRotation + 30)));
            this.C.set(this.mCenter.x + (this.mRadius - this.mPadding) * (float)Math.cos(Math.toRadians(this.mRotation + 150)), this.mCenter.y + (this.mRadius - this.mPadding) * (float)Math.sin(Math.toRadians(this.mRotation + 150)));
            this.path = new Path();
            this.path.moveTo(this.A.x, this.A.y);
            this.path.lineTo(this.B.x, this.B.y);
            this.path.lineTo(this.C.x, this.C.y);
            this.path.close();
        }

        protected void updateColorDependant(boolean hsvChanged, boolean hueChanged) {
            if (hueChanged) {
                LinearGradient base = new LinearGradient(this.A.x, this.A.y, (this.B.x + this.C.x) / 2.0f, (this.B.y + this.C.y) / 2.0f, Color.HSVToColor((float[])new float[]{this.mColor.hue(), 1.0f, 1.0f}), -16777216, Shader.TileMode.CLAMP);
                LinearGradient light = new LinearGradient((this.A.x + this.C.x) / 2.0f, (this.A.y + this.C.y) / 2.0f, this.B.x, this.B.y, -16777216, -1, Shader.TileMode.CLAMP);
                ComposeShader both = new ComposeShader((Shader)base, (Shader)light, PorterDuff.Mode.ADD);
                this.paint.setShader((Shader)both);
            }
            if (hsvChanged) {
                this.dotPaint.setColor(this.mColor.inverted().rgb());
                this.dot = new PointF(this.C.x + (this.B.x - this.C.x + (this.A.x - this.B.x) * this.mColor.sat()) * this.mColor.val(), this.C.y + (this.B.y - this.C.y + (this.A.y - this.B.y) * this.mColor.sat()) * this.mColor.val());
            }
        }

        C colorAt(PointF point) {
            PointF p = new PointF(point.x, point.y);
            float s = ((p.y - this.C.y) * (this.B.x - this.C.x) - (p.x - this.C.x) * (this.B.y - this.C.y)) / ((p.x - this.C.x) * (this.A.y - this.B.y) - (p.y - this.C.y) * (this.A.x - this.B.x));
            float v = (p.x - this.C.x) / ((this.A.x - this.B.x) * s + this.B.x - this.C.x);
            if (v < 0.0f) {
                s *= -1.0f;
            }
            C newColor = new C(this.mColor);
            newColor.sat(s);
            newColor.val(v);
            return newColor;
        }

        boolean encloses(PointF point) {
            boolean b1 = this.sign(point, this.A, this.B) < 0.0f;
            boolean b2 = this.sign(point, this.B, this.C) < 0.0f;
            boolean b3 = this.sign(point, this.C, this.A) < 0.0f;
            return b1 == b2 && b2 == b3;
        }

        private float sign(PointF p1, PointF p2, PointF p3) {
            return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
        }

        public void draw(Canvas canvas) {
            canvas.drawPath(this.path, this.paint);
            canvas.drawCircle(this.dot.x, this.dot.y, this.dotSize, this.dotPaint);
        }
    }

    private class TriangleWithSuggestions
    extends Triangle {
        private Field[] mFields = new Field[9];
        private Paint strokePaint = new Paint(1);

        TriangleWithSuggestions() {
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setColor(-256);
            for (int i = 0; i < this.mFields.length; ++i) {
                this.mFields[i] = new Field();
            }
        }

        private PointF calcInnerPoint(float R2, float p, float alpha, boolean pos) {
            float a = (float)Math.toRadians(alpha);
            float tan30 = (float)Math.tan(Math.toRadians(30.0));
            float x = alpha == 90.0f ? 0.0f : (float)((double)R2 / (1.0 + Math.tan(a) / (double)tan30));
            float y = alpha == 90.0f ? R2 * tan30 : (float)((double)x * Math.tan(a));
            float xy = (float)Math.sqrt(x * x + y * y);
            float b = (float)(pos ? Math.toRadians(30.0) + (double)a : Math.toRadians(150.0) - (double)a);
            float d = (float)(Math.abs((0.5 * Math.cos(b) - 1.0) / Math.sin(b)) * (double)p);
            float r = (float)Math.sqrt(Math.pow(xy + d, 2.0) + Math.pow(p, 2.0) / 4.0);
            float aId = (float)Math.asin(p / 2.0f / r);
            float aI = pos ? a + aId : a - aId;
            return new PointF(r * (float)Math.cos(aI), r * (float)Math.sin(aI));
        }

        private void createFieldGeometry(Field f, float startAngle, float sweepAngle) {
            int rot = (startAngle = ColorWheelView.this.mod(startAngle, 360.0f)) < 120.0f ? 0 : (startAngle < 240.0f ? 1 : 2);
            startAngle = ColorWheelView.this.mod(startAngle, 120.0f);
            float R2 = this.mRadius - this.mPadding;
            float p = this.mPadding;
            PointF p_i1 = this.calcInnerPoint(R2, p, startAngle, true);
            PointF p_i2 = this.calcInnerPoint(R2, p, startAngle + sweepAngle, false);
            float aAd = (float)Math.toDegrees(Math.asin(p / 2.0f / R2));
            float alpha_1 = startAngle + aAd;
            float alpha_2 = startAngle + sweepAngle - aAd;
            p_i1.offset(this.mCenter.x, this.mCenter.y);
            p_i2.offset(this.mCenter.x, this.mCenter.y);
            RectF oval = new RectF(this.mCenter.x - R2, this.mCenter.y - R2, this.mCenter.x + R2, this.mCenter.y + R2);
            f.rawPath = new Path();
            f.rawPath.moveTo(p_i1.x, p_i1.y);
            f.rawPath.arcTo(oval, alpha_1, alpha_2 - alpha_1);
            f.rawPath.lineTo(p_i2.x, p_i2.y);
            f.rawPath.close();
            Matrix mMatrix = new Matrix();
            mMatrix.postRotate((float)(-90 + rot * 120), this.mCenter.x, this.mCenter.y);
            f.rawPath.transform(mMatrix);
            f.startAngle = ColorWheelView.this.mod(alpha_1 - 90.0f + (float)(rot * 120), 360.0f);
            f.endAngle = ColorWheelView.this.mod(alpha_2 - 90.0f + (float)(rot * 120), 360.0f);
        }

        @Override
        protected void updateGeometryDependant() {
            super.updateGeometryDependant();
            for (int i = 0; i < this.mFields.length; ++i) {
                float alpha = 7.5f + (float)(35 * i) + (float)(15 * (i / 3));
                this.createFieldGeometry(this.mFields[i], alpha, 35.0f);
            }
        }

        @Override
        protected void updateRotationDependant() {
            super.updateRotationDependant();
            Matrix rotationMatrix = new Matrix();
            rotationMatrix.postRotate((float)this.mRotation, this.mCenter.x, this.mCenter.y);
            for (Field field : this.mFields) {
                field.rawPath.transform(rotationMatrix, field.cachedPath);
            }
        }

        @Override
        protected void updateColorDependant(boolean hsvChanged, boolean hueChanged) {
            super.updateColorDependant(hsvChanged, hueChanged);
            this.mFields[0].color = new C(this.mColor).sat(0.75f);
            this.mFields[1].color = new C(this.mColor).sat(0.5f);
            this.mFields[2].color = new C(this.mColor).sat(0.25f);
            this.mFields[3].color = new C(this.mColor).rotated(120);
            this.mFields[4].color = new C(this.mColor).rotated(180);
            this.mFields[5].color = new C(this.mColor).rotated(240);
            this.mFields[6].color = new C(this.mColor).val(0.25f);
            this.mFields[7].color = new C(this.mColor).val(0.5f);
            this.mFields[8].color = new C(this.mColor).val(0.75f);
            if (hsvChanged) {
                for (Field field : this.mFields) {
                    field.paint.setColor(field.color.rgb());
                }
            }
        }

        @Override
        public void draw(Canvas canvas) {
            super.draw(canvas);
            for (Field field : this.mFields) {
                canvas.drawPath(field.cachedPath, field.paint);
            }
        }

        C suggestionTouched(PointF pointer) {
            double r = Math.sqrt(Math.pow(pointer.x - this.mCenter.x, 2.0) + Math.pow(pointer.y - this.mCenter.y, 2.0));
            if (r > (double)(this.mRadius - this.mPadding)) {
                return null;
            }
            if (this.encloses(pointer)) {
                return null;
            }
            float phi = ColorWheelView.this.mod((float)(Math.toDegrees(Math.atan2(pointer.y - this.mCenter.y, pointer.x - this.mCenter.x)) - (double)this.mRotation), 360.0f);
            for (Field field : this.mFields) {
                if (!ColorWheelView.this.between(field.startAngle, phi, field.endAngle)) continue;
                return field.color;
            }
            return null;
        }

        private class Field {
            private Path rawPath = new Path();
            private Path cachedPath = new Path();
            private C color;
            private Paint paint;
            float startAngle;
            float endAngle;

            Field() {
                this.color = new C(-16777216);
                this.startAngle = 0.0f;
                this.endAngle = 0.0f;
                this.paint = new Paint(1);
                this.paint.setStyle(Paint.Style.FILL);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        float[] saveColor;
        int saveAlpha;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            in.readFloatArray(this.saveColor);
            this.saveAlpha = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloatArray(this.saveColor);
            out.writeInt(this.saveAlpha);
        }
    }

    private static enum Touch {
        NONE,
        TRIANGLE,
        SUGGESTION,
        HUE;

    }

    static enum Keep {
        WIDTH,
        HEIGHT;

    }

    private class C {
        private int alpha = 255;
        private float[] hsv = new float[3];

        C(int a, int h, float s, float v) {
            this.alpha(a);
            this.hue(h);
            this.sat(s);
            this.val(v);
        }

        C(int rgba) {
            float[] hsv = new float[3];
            Color.colorToHSV((int)rgba, (float[])hsv);
            int alpha = Color.alpha((int)rgba);
            this.alpha(alpha);
            this.hue((int)hsv[0]);
            this.sat(hsv[1]);
            this.val(hsv[2]);
        }

        C(C c) {
            this(c.alpha(), c.hue(), c.sat(), c.val());
        }

        boolean equalAlpha(C other) {
            return other.alpha == this.alpha;
        }

        boolean equalHSV(C other) {
            return other.hsv[0] == this.hsv[0] && other.hsv[1] == this.hsv[1] && other.hsv[2] == this.hsv[2];
        }

        boolean equalAlphaHSV(C other) {
            return this.equalAlpha(other) && this.equalHSV(other);
        }

        @Deprecated
        public boolean equals(Object o) {
            return super.equals(o) || o instanceof C && ((C)o).alpha == this.alpha && ((C)o).hsv[0] == this.hsv[0] && ((C)o).hsv[1] == this.hsv[1] && ((C)o).hsv[2] == this.hsv[2];
        }

        int rgb() {
            return Color.HSVToColor((float[])this.hsv);
        }

        int rgba() {
            return Color.HSVToColor((int)this.alpha, (float[])this.hsv);
        }

        int r() {
            return this.rgb() >> 16 & 0xFF;
        }

        int g() {
            return this.rgb() >> 8 & 0xFF;
        }

        int b() {
            return this.rgb() & 0xFF;
        }

        int alpha() {
            return this.alpha;
        }

        void alpha(int a) {
            this.alpha = a & 0xFF;
        }

        int hue() {
            return (int)this.hsv[0];
        }

        float sat() {
            return this.hsv[1];
        }

        float val() {
            return this.hsv[2];
        }

        C hue(int h) {
            this.hsv[0] = ColorWheelView.this.mod(h, 360.0f);
            return this;
        }

        C sat(float s) {
            this.hsv[1] = Math.min(1.0f, Math.max(0.0f, s));
            return this;
        }

        C val(float v) {
            this.hsv[2] = Math.min(1.0f, Math.max(0.0f, v));
            return this;
        }

        C inverted() {
            return new C(Color.argb((int)this.alpha, (int)(255 - this.r()), (int)(255 - this.g()), (int)(255 - this.b())));
        }

        C contrastColor() {
            if ((double)this.r() * 0.299 + (double)this.g() * 0.587 + (double)this.b() * 0.144 >= 128.0) {
                return new C(-16777216);
            }
            return new C(-1);
        }

        C rotated(int degrees) {
            return new C(this.alpha(), this.hue() + degrees, this.sat(), this.val());
        }
    }

    static interface OnColorChangeListener {
        public void onColorChange(int var1);
    }
}

