/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.os.Bundle;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;

public class SimpleCheckDialog
extends CustomViewDialog<SimpleCheckDialog> {
    public static final String CHECKED = "simpleCheckDialog.checked";
    private static final String CHECKBOX_LABEL = "simpleCheckDialog.check_label";
    private static final String CHECKBOX_REQUIRED = "simpleCheckDialog.check_required";
    private CheckBox mCheckBox;

    public static SimpleCheckDialog build() {
        return new SimpleCheckDialog();
    }

    public SimpleCheckDialog check(boolean preset) {
        return (SimpleCheckDialog)((Object)this.setArg(CHECKED, preset));
    }

    public SimpleCheckDialog label(String checkBoxLabel) {
        return (SimpleCheckDialog)((Object)this.setArg(CHECKBOX_LABEL, checkBoxLabel));
    }

    public SimpleCheckDialog label(@StringRes int checkBoxLabelResourceId) {
        return (SimpleCheckDialog)((Object)this.setArg(CHECKBOX_LABEL, checkBoxLabelResourceId));
    }

    public SimpleCheckDialog checkRequired(boolean required) {
        return (SimpleCheckDialog)((Object)this.setArg(CHECKBOX_REQUIRED, required));
    }

    private boolean canGoAhead() {
        return this.mCheckBox.isChecked() || !this.getArguments().getBoolean(CHECKBOX_REQUIRED);
    }

    @Override
    public View onCreateContentView(Bundle savedInstanceState) {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View view = inflater.inflate(R.layout.dialog_check_box, null);
        this.mCheckBox = (CheckBox)view.findViewById(R.id.checkBox);
        this.mCheckBox.setText((CharSequence)this.getArgString(CHECKBOX_LABEL));
        if (savedInstanceState != null) {
            this.mCheckBox.setChecked(savedInstanceState.getBoolean(CHECKED, false));
        } else {
            this.mCheckBox.setChecked(this.getArguments().getBoolean(CHECKED, false));
        }
        this.mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SimpleCheckDialog.this.setPositiveButtonEnabled(SimpleCheckDialog.this.canGoAhead());
            }
        });
        return view;
    }

    @Override
    protected void onDialogShown() {
        this.setPositiveButtonEnabled(this.canGoAhead());
    }

    @Override
    public Bundle onResult(int which) {
        Bundle result = new Bundle();
        result.putBoolean(CHECKED, this.mCheckBox.isChecked());
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(CHECKED, this.mCheckBox.isChecked());
    }
}

