/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.os.Bundle;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import java.util.ArrayList;
import java.util.List;

public abstract class CustomListDialog<This extends CustomListDialog<This>>
extends CustomViewDialog<This>
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    public static final int NO_CHOICE = 0;
    public static final int SINGLE_CHOICE = 1;
    public static final int SINGLE_CHOICE_DIRECT = 11;
    public static final int MULTI_CHOICE = 2;
    public static final String SELECTED_IDS = "customListDialog.selected_ids";
    public static final String SELECTED_POSITIONS = "customListDialog.selected_pos";
    public static final String SELECTED_SINGLE_ID = "customListDialog.selected_single_id";
    public static final String SELECTED_SINGLE_POSITION = "customListDialog.selected_single_pos";
    protected static final String CHOICE_MODE = "customListDialog.choice_mode";
    protected static final String CHOICE_MIN_COUNT = "customListDialog.choice_min";
    protected static final String CHOICE_MAX_COUNT = "customListDialog.choice_max";
    protected static final String INITIALLY_CHECKED_POSITIONS = "customListDialog.init_check";
    private boolean pmFlag = false;
    private ListView mListView;
    private ListAdapter mAdapter;

    protected abstract ListAdapter onCreateAdapter();

    public This choiceMode(int mode) {
        if (!this.pmFlag && mode == 11) {
            this.pos(null);
        }
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MODE, mode))));
    }

    public This choiceMin(int count) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MIN_COUNT, count))));
    }

    public This choiceMax(int count) {
        return (This)((Object)((CustomListDialog)((Object)this.setArg(CHOICE_MAX_COUNT, count))));
    }

    public This choicePreset(List<Integer> positions) {
        int[] p = new int[positions.size()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = positions.get(i);
        }
        return this.choicePreset(p);
    }

    public This choicePreset(int[] positions) {
        this.getArguments().putIntArray(INITIALLY_CHECKED_POSITIONS, positions);
        return (This)((Object)this);
    }

    @Override
    public This pos(String positiveButton) {
        this.pmFlag = true;
        return (This)((Object)((CustomListDialog)((Object)super.pos(positiveButton))));
    }

    @Override
    public This pos(int positiveButtonResourceId) {
        this.pmFlag = true;
        return (This)((Object)((CustomListDialog)((Object)super.pos(positiveButtonResourceId))));
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        return false;
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        int[] set;
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View view = inflater.inflate(R.layout.dialog_list, null);
        this.mListView = (ListView)view.findViewById(R.id.listView);
        this.mAdapter = this.onCreateAdapter();
        this.mListView.setAdapter(this.mAdapter);
        switch (this.getArguments().getInt(CHOICE_MODE, 0)) {
            case 1: 
            case 11: {
                this.mListView.setChoiceMode(1);
                break;
            }
            case 2: {
                this.mListView.setChoiceMode(2);
            }
        }
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CustomListDialog.this.updatePosButton();
                CustomListDialog.this.onItemClick(parent, view, position, id2);
                boolean checked = false;
                if (CustomListDialog.this.mListView.getCheckedItemPositions() != null) {
                    checked = CustomListDialog.this.mListView.getCheckedItemPositions().get(position);
                }
                if (checked && CustomListDialog.this.getArguments().getInt(CustomListDialog.CHOICE_MODE) == 11) {
                    CustomListDialog.this.pressPositiveButton();
                }
            }
        });
        this.mListView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        if (savedInstanceState == null && (set = this.getArguments().getIntArray(INITIALLY_CHECKED_POSITIONS)) != null) {
            for (int i : set) {
                this.mListView.setItemChecked(i, true);
            }
        }
        return view;
    }

    @Override
    protected void onDialogShown() {
        this.updatePosButton();
    }

    private void updatePosButton() {
        if (this.getArguments().getInt(CHOICE_MODE) == 0) {
            this.setPositiveButtonEnabled(true);
        } else {
            int min = this.getArguments().getInt(CHOICE_MIN_COUNT, -1);
            int max = this.getArguments().getInt(CHOICE_MAX_COUNT, -1);
            this.setPositiveButtonEnabled(!(min >= 0 && this.mListView.getCheckedItemCount() < min || max >= 0 && this.mListView.getCheckedItemCount() > max));
        }
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle result = new Bundle();
        if (this.getArguments().getInt(CHOICE_MODE) != 0) {
            ArrayList<Integer> checkedPositions = new ArrayList<Integer>(this.mListView.getCheckedItemCount());
            SparseBooleanArray sparse = this.mListView.getCheckedItemPositions();
            if (sparse != null) {
                for (int i = 0; i < this.mListView.getCount(); ++i) {
                    if (!sparse.get(i)) continue;
                    checkedPositions.add(i);
                }
            }
            result.putIntegerArrayList(SELECTED_POSITIONS, checkedPositions);
            if (this.mAdapter.hasStableIds()) {
                result.putLongArray(SELECTED_IDS, this.mListView.getCheckedItemIds());
            }
        }
        if (this.getArguments().getInt(CHOICE_MODE) == 1 || this.getArguments().getInt(CHOICE_MODE) == 11) {
            int pos = this.mListView.getCheckedItemPosition();
            result.putInt(SELECTED_SINGLE_POSITION, pos);
            if (this.mAdapter.hasStableIds()) {
                result.putLong(SELECTED_SINGLE_ID, this.mAdapter.getItemId(pos));
            }
        }
        return result;
    }
}

