/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.shadow_lib;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class ShadowUtils {
    @NonNull
    public static Bitmap addShadow(@NonNull Bitmap bitmap, @ColorInt int shadowColor, float shadowRadiusDp, float offsetXDp, float offsetYDp) {
        return ShadowUtils.addShadow(bitmap, bitmap.getWidth(), bitmap.getHeight(), shadowColor, shadowRadiusDp, offsetXDp, offsetYDp);
    }

    @NonNull
    public static Bitmap addShadow(@NonNull Bitmap bitmap, int destWidth, int destHeight, @ColorInt int shadowColor, float shadowRadiusDp, float offsetXDp, float offsetYDp) {
        float shadowRadius = ShadowUtils.dpToPx(shadowRadiusDp);
        float offsetX = ShadowUtils.dpToPx(offsetXDp);
        float offsetY = ShadowUtils.dpToPx(offsetYDp);
        Matrix scaleToFitMatrix = new Matrix();
        if (bitmap.getWidth() != destWidth || bitmap.getHeight() != destHeight) {
            RectF source = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            RectF destination = new RectF(0.0f, 0.0f, (float)destWidth, (float)destHeight);
            scaleToFitMatrix.setRectToRect(source, destination, Matrix.ScaleToFit.CENTER);
        }
        Matrix dropShadowMatrix = new Matrix(scaleToFitMatrix);
        dropShadowMatrix.postTranslate(offsetX, offsetY);
        Bitmap maskBitmap = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        Canvas maskCanvas = new Canvas(maskBitmap);
        maskCanvas.drawBitmap(bitmap, dropShadowMatrix, null);
        BlurMaskFilter filter = new BlurMaskFilter(shadowRadius, BlurMaskFilter.Blur.NORMAL);
        Paint blurPaint = new Paint(1);
        blurPaint.setColor(shadowColor);
        blurPaint.setMaskFilter((MaskFilter)filter);
        blurPaint.setFilterBitmap(true);
        Bitmap result = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas resultCanvas = new Canvas(result);
        resultCanvas.drawBitmap(maskBitmap, 0.0f, 0.0f, blurPaint);
        resultCanvas.drawBitmap(bitmap, scaleToFitMatrix, null);
        maskBitmap.recycle();
        return result;
    }

    private static float dpToPx(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }
}

