/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import java.util.HashMap;
import java.util.Map;
import top.defaults.view.EffectSettings;
import top.defaults.view.TextButtonEffect;
import top.defaults.view.clickabletextview.R;

public class TextButton
extends AppCompatTextView {
    private static final boolean DEBUG = false;
    @ColorInt
    int defaultTextColor;
    @ColorInt
    int pressedTextColor;
    @ColorInt
    int disabledTextColor;
    boolean isUnderlined;
    int effectType;
    int effectDuration;
    private TextButtonEffect effect;

    public TextButton(Context context) {
        this(context, null);
    }

    public TextButton(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClickable(true);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextButton);
        this.defaultTextColor = typedArray.getColor(R.styleable.TextButton_defaultTextColor, this.getCurrentTextColor());
        this.pressedTextColor = typedArray.getColor(R.styleable.TextButton_pressedTextColor, this.calculatePressedColor(this.defaultTextColor));
        this.disabledTextColor = typedArray.getColor(R.styleable.TextButton_disabledTextColor, this.calculateDisabledColor(this.defaultTextColor));
        this.isUnderlined = typedArray.getBoolean(R.styleable.TextButton_underline, false);
        this.effectType = typedArray.getInt(R.styleable.TextButton_effect, 0);
        this.effectDuration = typedArray.getInt(R.styleable.TextButton_effectDuration, -1);
        typedArray.recycle();
        this.effect = TextButtonEffect.Factory.create(this);
        this.apply();
    }

    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(10);
        settings.put("key_default_text_color", this.defaultTextColor);
        settings.put("key_pressed_text_color", this.pressedTextColor);
        settings.put("key_disabled_text_color", this.disabledTextColor);
        settings.put("key_is_underlined", this.isUnderlined);
        settings.put("key_effect_duration", this.effectDuration);
        EffectSettings.reviewSettings(this.effectType, settings);
        return settings;
    }

    public void setEffect(TextButtonEffect effect) {
        if (effect == null) {
            effect = TextButtonEffect.Factory.create(this);
        }
        this.effect = effect;
        this.apply();
    }

    private void apply() {
        this.effect.init(this);
        if (this.isUnderlined) {
            this.setPaintFlags(this.getPaintFlags() | 8);
        }
        this.setGravity(17);
    }

    private int calculatePressedColor(@ColorInt int defaultColor) {
        int alpha = Color.alpha((int)defaultColor);
        alpha = Math.max(16, alpha - 96);
        return Color.argb((int)alpha, (int)Color.red((int)defaultColor), (int)Color.green((int)defaultColor), (int)Color.blue((int)defaultColor));
    }

    private int calculateDisabledColor(@ColorInt int defaultColor) {
        int alpha = Color.alpha((int)defaultColor);
        float[] hsv = new float[3];
        Color.colorToHSV((int)defaultColor, (float[])hsv);
        hsv[1] = Math.max(0.0f, hsv[1] - 0.4f);
        return Color.HSVToColor((int)alpha, (float[])hsv);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (!this.isEnabled() || !this.isClickable()) break;
                this.effect.actionDown();
                break;
            }
            case 1: {
                this.effect.actionUp();
            }
        }
        return super.onTouchEvent(event);
    }
}

