/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Environment;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.TextureView;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.defaults.camera.Error;

public class Utils {
    private static Pattern pattern = Pattern.compile("^#(\\d+), (.+)");
    private static String fileDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/TopDefaultsCamera/";
    private static final int FOCUS_AREA_SIZE = 150;
    private static final int SENSOR_ORIENTATION_DEFAULT_DEGREES = 90;
    private static final int SENSOR_ORIENTATION_INVERSE_DEGREES = 270;
    private static final SparseIntArray DEFAULT_ORIENTATIONS = new SparseIntArray();
    private static final SparseIntArray INVERSE_ORIENTATIONS = new SparseIntArray();

    static String exceptionMessage(int code, String message) {
        return String.format(Locale.getDefault(), "#%d, %s", code, message);
    }

    private static int codeFromThrowable(Throwable throwable, int fallback) {
        Matcher matcher;
        int errorCode = fallback;
        String message = throwable.getMessage();
        if (message != null && (matcher = pattern.matcher(message)).find()) {
            errorCode = Integer.parseInt(matcher.group(1));
        }
        return errorCode;
    }

    private static String messageFromThrowable(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.toString();
        } else {
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                message = matcher.group(2);
            }
        }
        return message;
    }

    static Error errorFromThrowable(Throwable throwable) {
        return Utils.errorFromThrowable(throwable, -1);
    }

    private static Error errorFromThrowable(Throwable throwable, int fallback) {
        return new Error(Utils.codeFromThrowable(throwable, fallback), Utils.messageFromThrowable(throwable));
    }

    static boolean napInterrupted() {
        return !Utils.sleep(1L);
    }

    private static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean getBoolean(Map<String, Object> params, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof Boolean) {
            value = (Boolean)valueObject;
        }
        return value;
    }

    static int getInt(Map<String, Object> params, String key, int defaultValue) {
        int value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof Integer) {
            value = (Integer)valueObject;
        }
        return value;
    }

    static String getString(Map<String, Object> params, String key, String defaultValue) {
        String value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof String && (value = (String)valueObject).length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public static void addMediaToGallery(Context context, String photoPath) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File photoFile = new File(photoPath);
        Uri contentUri = Uri.fromFile((File)photoFile);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    static String getImageFilePath() throws IOException {
        return Utils.getFilePath(".jpg");
    }

    static String getVideoFilePath() throws IOException {
        return Utils.getFilePath(".mp4");
    }

    static void setFileDir(String fileDir) {
        Utils.fileDir = fileDir;
    }

    private static String getFilePath(String fileSuffix) throws IOException {
        boolean result;
        File dir = new File(fileDir);
        if (!dir.exists() && !(result = dir.mkdirs())) {
            throw new IOException(Utils.exceptionMessage(4, "Unable to create folder"));
        }
        return dir.getAbsolutePath() + "/" + System.currentTimeMillis() + fileSuffix;
    }

    static boolean checkFloatEqual(float a, float b) {
        return (double)Math.abs(a - b) < 0.001;
    }

    static Rect calculateFocusArea(Rect sensorArraySize, int displayOrientation, TextureView textureView, MotionEvent event) {
        int focusY;
        int focusX;
        int eventX = (int)event.getX();
        int eventY = (int)event.getY();
        switch (displayOrientation) {
            case 0: {
                focusX = (int)((float)eventX / (float)textureView.getWidth() * (float)sensorArraySize.width());
                focusY = (int)((float)eventY / (float)textureView.getHeight() * (float)sensorArraySize.height());
                break;
            }
            case 180: {
                focusX = (int)((1.0f - (float)eventX / (float)textureView.getWidth()) * (float)sensorArraySize.width());
                focusY = (int)((1.0f - (float)eventY / (float)textureView.getHeight()) * (float)sensorArraySize.height());
                break;
            }
            case 270: {
                focusX = (int)((1.0f - (float)eventY / (float)textureView.getHeight()) * (float)sensorArraySize.width());
                focusY = (int)((float)eventX / (float)textureView.getWidth() * (float)sensorArraySize.height());
                break;
            }
            default: {
                focusX = (int)((float)eventY / (float)textureView.getHeight() * (float)sensorArraySize.width());
                focusY = (int)((1.0f - (float)eventX / (float)textureView.getWidth()) * (float)sensorArraySize.height());
            }
        }
        int left = Math.max(focusX - 150, 0);
        int top = Math.max(focusY - 150, 0);
        int right = Math.min(left + 300, sensorArraySize.width());
        int bottom = Math.min(top + 300, sensorArraySize.width());
        return new Rect(left, top, right, bottom);
    }

    static int getDisplayOrientation(Activity activity, int sensorOrientation) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        return Utils.getOrientation(sensorOrientation, rotation);
    }

    static int getOrientation(int sensorOrientation, int displayRotation) {
        int degree = DEFAULT_ORIENTATIONS.get(displayRotation);
        switch (sensorOrientation) {
            case 90: {
                degree = DEFAULT_ORIENTATIONS.get(displayRotation);
                break;
            }
            case 270: {
                degree = INVERSE_ORIENTATIONS.get(displayRotation);
            }
        }
        return degree;
    }

    static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static {
        DEFAULT_ORIENTATIONS.append(0, 90);
        DEFAULT_ORIENTATIONS.append(1, 0);
        DEFAULT_ORIENTATIONS.append(2, 270);
        DEFAULT_ORIENTATIONS.append(3, 180);
        INVERSE_ORIENTATIONS.append(0, 270);
        INVERSE_ORIENTATIONS.append(1, 180);
        INVERSE_ORIENTATIONS.append(2, 90);
        INVERSE_ORIENTATIONS.append(3, 0);
    }
}

