/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.support.annotation.NonNull;
import top.defaults.camera.Error;

class FocusHandler {
    private boolean isFocusProcessing;

    FocusHandler() {
    }

    void focus(CameraCaptureSession captureSession, final CaptureRequest.Builder captureRequestBuilder, Rect focusArea, final Callback callback) {
        if (this.isFocusProcessing) {
            return;
        }
        try {
            captureSession.stopRepeating();
        }
        catch (CameraAccessException e) {
            callback.onFinish(new Error(1, (Throwable)e));
            return;
        }
        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
        if (focusArea != null) {
            MeteringRectangle rectangle = new MeteringRectangle(focusArea, 999);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{rectangle});
        }
        captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        captureRequestBuilder.setTag((Object)"FOCUS_TAG");
        try {
            CameraCaptureSession.CaptureCallback focusCallbackHandler = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    FocusHandler.this.isFocusProcessing = false;
                    if (request.getTag() == "FOCUS_TAG") {
                        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, null);
                        callback.onFinish(null);
                    }
                }

                public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
                    FocusHandler.this.isFocusProcessing = false;
                    callback.onFinish(new Error(1, "focus failed"));
                }
            };
            captureSession.capture(captureRequestBuilder.build(), focusCallbackHandler, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            callback.onFinish(new Error(1, (Throwable)e));
            return;
        }
        this.isFocusProcessing = true;
    }

    static interface Callback {
        public void onFinish(Error var1);
    }
}

