/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import java.util.LinkedList;
import java.util.List;
import top.defaults.camera.AspectRatio;
import top.defaults.camera.AutoFitTextureView;
import top.defaults.camera.CameraViewOverlay;
import top.defaults.camera.CanvasDrawer;
import top.defaults.camera.DisplayOrientationDetector;
import top.defaults.camera.InternalPhotographer;
import top.defaults.camera.R;

public class CameraView
extends RelativeLayout {
    private Context context;
    private AutoFitTextureView textureView;
    private CameraViewOverlay overlay;
    private final DisplayOrientationDetector displayOrientationDetector;
    private String aspectRatio;
    private boolean autoFocus;
    private int facing;
    private int flash;
    private int mode;
    private boolean pinchToZoom;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private List<Callback> callbacks = new LinkedList<Callback>();

    public CameraView(@NonNull Context context) {
        this(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.textureView = new AutoFitTextureView(context);
        this.textureView.setId(R.id.textureView);
        RelativeLayout.LayoutParams textureViewParams = new RelativeLayout.LayoutParams(-2, -2);
        textureViewParams.addRule(13);
        this.addView((View)this.textureView, (ViewGroup.LayoutParams)textureViewParams);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraView);
        this.aspectRatio = typedArray.getString(R.styleable.CameraView_aspectRatio);
        this.autoFocus = typedArray.getBoolean(R.styleable.CameraView_autoFocus, true);
        this.facing = typedArray.getInt(R.styleable.CameraView_facing, 0);
        this.flash = typedArray.getInt(R.styleable.CameraView_flash, 0);
        this.mode = typedArray.getInt(R.styleable.CameraView_mode, 0);
        boolean fillSpace = typedArray.getBoolean(R.styleable.CameraView_fillSpace, false);
        this.textureView.setFillSpace(fillSpace);
        this.pinchToZoom = typedArray.getBoolean(R.styleable.CameraView_pinchToZoom, true);
        boolean showFocusIndicator = typedArray.getBoolean(R.styleable.CameraView_showFocusIndicator, true);
        typedArray.recycle();
        this.addOverlay();
        if (showFocusIndicator) {
            this.setFocusIndicatorDrawer(new CanvasDrawer.DefaultCanvasDrawer());
        }
        this.displayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.textureView.setDisplayOrientation(displayOrientation);
            }
        };
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                CameraView.this.dispatchOnSingleTap(e);
                return true;
            }
        });
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                if (CameraView.this.pinchToZoom) {
                    CameraView.this.dispatchOnScale(detector.getScaleFactor());
                }
                return true;
            }
        });
        this.textureView.setOnTouchListener((v, event) -> {
            if (this.gestureDetector.onTouchEvent(event)) {
                return true;
            }
            if (this.scaleGestureDetector.onTouchEvent(event)) {
                return true;
            }
            return true;
        });
    }

    void assign(InternalPhotographer photographer) {
        photographer.setMode(this.mode);
        photographer.setAspectRatio(AspectRatio.parse(this.aspectRatio));
        photographer.setAutoFocus(this.autoFocus);
        photographer.setFacing(this.facing);
        photographer.setFlash(this.flash);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.displayOrientationDetector.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.displayOrientationDetector.disable();
        }
        super.onDetachedFromWindow();
    }

    AutoFitTextureView getTextureView() {
        return this.textureView;
    }

    public boolean isFillSpace() {
        return this.textureView.isFillSpace();
    }

    public void setFillSpace(boolean fillSpace) {
        this.textureView.setFillSpace(fillSpace);
    }

    public void setPinchToZoom(boolean pinchToZoom) {
        this.pinchToZoom = pinchToZoom;
    }

    private void addOverlay() {
        this.overlay = new CameraViewOverlay(this.context);
        RelativeLayout.LayoutParams overlayParams = new RelativeLayout.LayoutParams(-2, -2);
        overlayParams.addRule(5, R.id.textureView);
        overlayParams.addRule(6, R.id.textureView);
        overlayParams.addRule(7, R.id.textureView);
        overlayParams.addRule(8, R.id.textureView);
        this.addView((View)this.overlay, (ViewGroup.LayoutParams)overlayParams);
    }

    public void setFocusIndicatorDrawer(CanvasDrawer drawer) {
        this.overlay.setCanvasDrawer(drawer);
    }

    void focusRequestAt(int x, int y) {
        this.overlay.focusRequestAt(x, y);
    }

    void focusFinished() {
        this.overlay.focusFinished();
    }

    void shot() {
        this.overlay.shot();
    }

    public void addCallback(Callback callback) {
        if (callback != null) {
            this.callbacks.add(callback);
            this.textureView.addCallback(callback);
        }
    }

    private void dispatchOnSingleTap(MotionEvent e) {
        for (Callback callback : this.callbacks) {
            callback.onSingleTap(e);
        }
    }

    private void dispatchOnScale(float scaleFactor) {
        for (Callback callback : this.callbacks) {
            callback.onScale(scaleFactor);
        }
    }

    public static interface Callback
    extends AutoFitTextureView.Callback {
        public void onSingleTap(MotionEvent var1);

        public void onScale(float var1);
    }
}

