/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.animation.DecelerateInterpolator;
import top.defaults.camera.CanvasDrawer;

class CameraViewOverlay
extends SurfaceView {
    private SurfaceHolder holder;
    private Point focusPoint;
    private CanvasDrawer canvasDrawer;
    private Paint[] paints;
    private static final int SHUTTER_ONE_WAY_TIME = 150;

    public CameraViewOverlay(Context context) {
        this(context, null);
    }

    public CameraViewOverlay(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraViewOverlay(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setZOrderOnTop(true);
        this.holder = this.getHolder();
        this.holder.setFormat(-2);
        this.holder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                CameraViewOverlay.this.clear();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                CameraViewOverlay.this.clear();
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
    }

    public void setCanvasDrawer(CanvasDrawer drawer) {
        this.canvasDrawer = drawer;
        this.paints = drawer.initPaints();
    }

    void focusRequestAt(int x, int y) {
        if (x >= 0 && x <= this.getMeasuredWidth() && y >= 0 && y <= this.getMeasuredHeight()) {
            this.focusPoint = new Point(x, y);
        }
        this.drawIndicator();
    }

    void focusFinished() {
        this.focusPoint = null;
        this.postDelayed(this::clear, 300L);
    }

    private void drawIndicator() {
        Canvas canvas;
        this.invalidate();
        if (this.holder.getSurface().isValid() && (canvas = this.holder.lockCanvas()) != null) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawColor(0);
            if (this.canvasDrawer != null) {
                this.canvasDrawer.draw(canvas, this.focusPoint, this.paints);
            }
            this.holder.unlockCanvasAndPost(canvas);
        }
    }

    private void clear() {
        Canvas canvas = this.holder.lockCanvas();
        if (canvas != null) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.holder.unlockCanvasAndPost(canvas);
        }
    }

    public void shot() {
        final int colorFrom = 0;
        int colorTo = -1358954496;
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        colorAnimation.setDuration(150L);
        colorAnimation.addUpdateListener(animator -> this.setBackgroundColor((Integer)animator.getAnimatedValue()));
        colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                CameraViewOverlay.this.setBackgroundColor(colorFrom);
            }
        });
        colorAnimation.start();
        this.postDelayed(() -> ((ValueAnimator)colorAnimation).reverse(), 150L);
    }
}

