/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.repackaged.org.jaxen.function;

import com.github.dnault.xmlpatch.repackaged.org.jaxen.Context;
import com.github.dnault.xmlpatch.repackaged.org.jaxen.Function;
import com.github.dnault.xmlpatch.repackaged.org.jaxen.FunctionCallException;
import com.github.dnault.xmlpatch.repackaged.org.jaxen.Navigator;
import com.github.dnault.xmlpatch.repackaged.org.jaxen.function.StringFunction;
import java.util.List;

public class NormalizeSpaceFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 0) {
            return NormalizeSpaceFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args.size() == 1) {
            return NormalizeSpaceFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("normalize-space() cannot have more than one argument");
    }

    public static String evaluate(Object strArg, Navigator nav) {
        String str = StringFunction.evaluate(strArg, nav);
        char[] buffer = str.toCharArray();
        int write = 0;
        int lastWrite = 0;
        boolean wroteOne = false;
        int read = 0;
        while (read < buffer.length) {
            if (NormalizeSpaceFunction.isXMLSpace(buffer[read])) {
                if (wroteOne) {
                    buffer[write++] = 32;
                }
                while (++read < buffer.length && NormalizeSpaceFunction.isXMLSpace(buffer[read])) {
                }
                continue;
            }
            buffer[write++] = buffer[read++];
            wroteOne = true;
            lastWrite = write;
        }
        return new String(buffer, 0, lastWrite);
    }

    private static boolean isXMLSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }
}

