/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.batch;

import com.github.dnault.xmlpatch.batch.PatchAssembler;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.Element;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AssembledPatch {
    private LinkedHashSet<File> patchFiles = new LinkedHashSet();
    private List<Element> diffs = new ArrayList<Element>();
    private Set<String> accessedPaths = new HashSet<String>();

    public AssembledPatch() {
    }

    public AssembledPatch(File patch) throws Exception {
        new PatchAssembler().assembleRecursive(patch, this);
    }

    public LinkedHashSet<File> getPatchFiles() {
        return this.patchFiles;
    }

    public boolean addPatchFile(File includedFile) {
        return this.patchFiles.add(includedFile);
    }

    public List<Element> getDiffs() {
        return this.diffs;
    }

    public List<Element> getDiffs(String sourcePath) {
        Objects.requireNonNull(sourcePath);
        ArrayList<Element> matchingDiffs = new ArrayList<Element>(0);
        for (Element e : this.diffs) {
            if (!sourcePath.equals(e.getAttributeValue("file"))) continue;
            matchingDiffs.add(e);
            this.accessedPaths.add(sourcePath);
        }
        return matchingDiffs;
    }

    public Set<String> getSourcePaths() {
        HashSet<String> sourcePaths = new HashSet<String>();
        for (Element e : this.diffs) {
            sourcePaths.add(e.getAttributeValue("file"));
        }
        return sourcePaths;
    }

    public Set<String> getAccessedPaths() {
        return this.accessedPaths;
    }

    public void addDif(Element diff) {
        this.diffs.add(diff);
    }
}

