/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch;

import com.github.dnault.xmlpatch.Patcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CommandLineDriver {
    public static void main(String ... args) throws Exception {
        boolean patchInPlace;
        if (args.length == 0) {
            CommandLineDriver.usage();
            System.exit(0);
        }
        if (args.length != 3) {
            System.err.println("incorrect number of arguments");
            CommandLineDriver.usage();
            System.exit(1);
        }
        String input = args[0];
        String patch = args[1];
        String output = args[2];
        if (input.equals("-") && patch.equals("-")) {
            System.err.println("input and patch may not both come from standard input");
            System.exit(1);
        }
        boolean bl = patchInPlace = !input.equals("-") && CommandLineDriver.isSameFile(input, output);
        if (patchInPlace) {
            output = File.createTempFile("xmlpatch", ".xml").getAbsolutePath();
        }
        try {
            InputStream inputStream = input.equals("-") ? System.in : new FileInputStream(input);
            InputStream patchStream = patch.equals("-") ? System.in : new FileInputStream(patch);
            OutputStream outputStream = output.equals("-") ? System.out : new FileOutputStream(output);
            Patcher.patch(inputStream, patchStream, outputStream);
            if (patchInPlace && !new File(output).renameTo(new File(input))) {
                throw new IOException("could not rename temp file to " + input);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Could not access file: " + e.getMessage());
            System.exit(1);
        }
    }

    private static boolean isSameFile(String pathA, String pathB) throws IOException {
        return new File(pathA).getCanonicalPath().equals(new File(pathB).getCanonicalPath());
    }

    private static void usage() {
        System.err.println("USAGE: java -jar xml-patch.jar <input file> <patch file> <output file>");
        System.err.println("  A dash (-) may be used to indicate standard input / output");
        System.err.println("  The patch is an XML diff document as defined by RFC 5261");
        System.err.println("  or an XML patch document as defined by RFC 7351");
        System.exit(1);
    }
}

