/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.filter;

import com.github.dnault.xmlpatch.CommandLineDriver;
import com.github.dnault.xmlpatch.internal.DeferredInitFilterReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class XmlPatch
extends DeferredInitFilterReader {
    private String patch;
    private File output;

    public XmlPatch(Reader in) {
        super(in);
    }

    public void setPatch(String patch) {
        if (patch != null) {
            patch = new File(patch).getAbsolutePath();
        }
        this.patch = patch;
    }

    public String getPatch() {
        return this.patch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.patch == null) {
            throw new RuntimeException("missing 'patch' parameter, path to patch file");
        }
        try {
            File input = File.createTempFile("xml-patch-input-", ".xml");
            try {
                this.output = File.createTempFile("xml-patch-result-", ".xml");
                try (FileOutputStream os = new FileOutputStream(input);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
                     Reader reader = this.in;){
                    IOUtils.copy((Reader)reader, (Writer)writer);
                }
                CommandLineDriver.main(input.getAbsolutePath(), this.patch, this.output.getAbsolutePath());
                this.in = new FileReader(this.output);
            }
            finally {
                FileUtils.deleteQuietly((File)input);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            FileUtils.deleteQuietly((File)this.output);
        }
    }
}

