/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.batch;

import com.github.dnault.xmlpatch.batch.AssembledPatch;
import com.github.dnault.xmlpatch.internal.Log;
import com.github.dnault.xmlpatch.internal.XmlHelper;
import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;

public class PatchAssembler {
    public AssembledPatch assemble(File patchFile) throws Exception {
        AssembledPatch assembled = new AssembledPatch();
        this.assembleRecursive(patchFile, assembled);
        return assembled;
    }

    protected void assembleRecursive(File patchFile, AssembledPatch assembled) throws Exception {
        String path = patchFile.getAbsolutePath();
        if (!assembled.addPatchFile(patchFile)) {
            return;
        }
        Log.info("Reading XML patch file: " + path);
        Document doc = XmlHelper.parse(patchFile);
        Element batchElement = doc.getRootElement();
        if (!batchElement.getName().equals("diffs")) {
            throw new IllegalArgumentException(path + ": expected root element of patch document to be 'diffs' but found '" + batchElement.getName() + "'");
        }
        for (Element diff : XmlHelper.getChildren(batchElement)) {
            if (diff.getName().equals("include")) {
                String includeFilename = diff.getAttributeValue("file");
                if (includeFilename == null) {
                    throw new IllegalArgumentException(path + ": element 'include' missing 'file' attribute");
                }
                File includeFile = new File(patchFile.getParent(), includeFilename);
                this.assembleRecursive(includeFile, assembled);
                continue;
            }
            if (!diff.getName().equals("diff")) {
                throw new IllegalArgumentException(path + ": unexpected element '" + diff.getName() + "' in patch document, expected 'diff' or 'include'");
            }
            if (diff.getAttribute("file") == null) {
                throw new IllegalArgumentException(path + ": 'diff' element missing 'file' attribute");
            }
            assembled.addDif(diff.clone());
        }
    }
}

