/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CropProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mCropAspectX", "", "mCropAspectY", "mCropImageFile", "Ljava/io/File;", "mMaxHeight", "", "mMaxWidth", "cropImage", "", "file", "handleResult", "isCropEnabled", "", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onFailure", "startIntent", "Companion", "imagepicker_release"})
public final class CropProvider
extends BaseProvider {
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final float mCropAspectX;
    private final float mCropAspectY;
    private File mCropImageFile;
    private static final String TAG;
    public static final Companion Companion;

    public final boolean isCropEnabled() {
        return this.mCropAspectX > 0.0f && this.mCropAspectY > 0.0f;
    }

    public final void startIntent(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.cropImage(file);
    }

    private final void cropImage(File file) throws IOException {
        block9: {
            block8: {
                this.mCropImageFile = FileUtil.INSTANCE.getCameraFile();
                if (this.mCropImageFile == null) break block8;
                File file2 = this.mCropImageFile;
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                if (file2.exists()) break block9;
            }
            Log.e((String)TAG, (String)"Failed to create crop image file");
            this.setError(R.string.error_failed_to_crop_image);
            return;
        }
        UCrop.Options options = new UCrop.Options();
        UCrop uCrop = UCrop.of((Uri)Uri.fromFile((File)file), (Uri)Uri.fromFile((File)this.mCropImageFile)).withOptions(options);
        if (this.mCropAspectX > 0.0f && this.mCropAspectY > 0.0f) {
            uCrop.withAspectRatio(this.mCropAspectX, this.mCropAspectY);
        }
        if (this.mMaxWidth > 0 && this.mMaxHeight > 0) {
            uCrop.withMaxResultSize(this.mMaxWidth, this.mMaxHeight);
        }
        try {
            uCrop.start((Activity)this.getActivity(), 69);
        }
        catch (ActivityNotFoundException ex) {
            this.setError("uCrop not specified in manifest file.Add UCropActivity in Manifest<activity\n    android:name=\"com.yalantis.ucrop.UCropActivity\"\n    android:screenOrientation=\"portrait\"\n    android:theme=\"@style/Theme.AppCompat.Light.NoActionBar\"/>");
            ex.printStackTrace();
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 69) {
            if (resultCode == -1) {
                this.handleResult(this.mCropImageFile);
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult(File file) {
        if (file != null) {
            this.getActivity().setCropImage(file);
        } else {
            this.setError(R.string.error_failed_to_crop_image);
        }
    }

    @Override
    protected void onFailure() {
        block0: {
            File file = this.mCropImageFile;
            if (file == null) break block0;
            file.delete();
        }
    }

    public CropProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
        super(activity);
        Intent intent = activity.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        Bundle bundle2 = bundle;
        this.mMaxWidth = bundle2.getInt("extra.max_width", 0);
        this.mMaxHeight = bundle2.getInt("extra.max_height", 0);
        this.mCropAspectX = bundle2.getFloat("extra.crop_x", 0.0f);
        this.mCropAspectY = bundle2.getFloat("extra.crop_y", 0.0f);
    }

    static {
        Companion = new Companion(null);
        TAG = CropProvider.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CropProvider$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

