/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.github.dhaval2404.imagepicker.R;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\u0004H\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/github/dhaval2404/imagepicker/util/IntentUtils;", "", "()V", "getCameraIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getGalleryDocumentIntent", "getGalleryIntent", "getGalleryPickIntent", "isCameraHardwareAvailable", "", "imagepicker-support_release"})
public final class IntentUtils {
    public static final IntentUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Intent getGalleryIntent(@NotNull Context context) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 19) {
            void var2_2;
            Intent intent2 = this.getGalleryDocumentIntent();
            if (intent2.resolveActivity(context.getPackageManager()) == null) {
                intent2 = this.getGalleryPickIntent();
            }
            intent = var2_2;
        } else {
            intent = this.getGalleryPickIntent();
        }
        return intent;
    }

    private final Intent getGalleryDocumentIntent() {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("image/*");
        return intent;
    }

    private final Intent getGalleryPickIntent() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        return intent;
    }

    @Nullable
    public final Intent getCameraIntent(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = context.getPackageName() + context.getString(R.string.image_picker_provider_authority_suffix);
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            intent.putExtra("output", (Parcelable)photoURI);
        } else {
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        }
        return intent;
    }

    public final boolean isCameraHardwareAvailable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return context.getPackageManager().hasSystemFeature("android.hardware.camera.any");
    }

    private IntentUtils() {
    }

    static {
        IntentUtils intentUtils;
        INSTANCE = intentUtils = new IntentUtils();
    }
}

